/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.InsightConfiguration;
import java.util.List;

@SdkInternalApi
public class InsightConfigurationMarshaller {
    private static final MarshallingInfo<List> COMPUTATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Computations").build();
    private static final MarshallingInfo<StructuredPojo> CUSTOMNARRATIVE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CustomNarrative").build();
    private static final MarshallingInfo<StructuredPojo> INTERACTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Interactions").build();
    private static final InsightConfigurationMarshaller instance = new InsightConfigurationMarshaller();

    public static InsightConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(InsightConfiguration insightConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (insightConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(insightConfiguration.getComputations(), COMPUTATIONS_BINDING);
            protocolMarshaller.marshall((Object)insightConfiguration.getCustomNarrative(), CUSTOMNARRATIVE_BINDING);
            protocolMarshaller.marshall((Object)insightConfiguration.getInteractions(), INTERACTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

