/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.quicksight.model.SheetDefinition;
import java.util.List;

@SdkInternalApi
public class SheetDefinitionMarshaller {
    private static final MarshallingInfo<String> SHEETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SheetId").build();
    private static final MarshallingInfo<String> TITLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Title").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<List> PARAMETERCONTROLS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParameterControls").build();
    private static final MarshallingInfo<List> FILTERCONTROLS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FilterControls").build();
    private static final MarshallingInfo<List> VISUALS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Visuals").build();
    private static final MarshallingInfo<List> TEXTBOXES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TextBoxes").build();
    private static final MarshallingInfo<List> LAYOUTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Layouts").build();
    private static final MarshallingInfo<List> SHEETCONTROLLAYOUTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SheetControlLayouts").build();
    private static final MarshallingInfo<String> CONTENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContentType").build();
    private static final SheetDefinitionMarshaller instance = new SheetDefinitionMarshaller();

    public static SheetDefinitionMarshaller getInstance() {
        return instance;
    }

    public void marshall(SheetDefinition sheetDefinition, ProtocolMarshaller protocolMarshaller) {
        if (sheetDefinition == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)sheetDefinition.getSheetId(), SHEETID_BINDING);
            protocolMarshaller.marshall((Object)sheetDefinition.getTitle(), TITLE_BINDING);
            protocolMarshaller.marshall((Object)sheetDefinition.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)sheetDefinition.getName(), NAME_BINDING);
            protocolMarshaller.marshall(sheetDefinition.getParameterControls(), PARAMETERCONTROLS_BINDING);
            protocolMarshaller.marshall(sheetDefinition.getFilterControls(), FILTERCONTROLS_BINDING);
            protocolMarshaller.marshall(sheetDefinition.getVisuals(), VISUALS_BINDING);
            protocolMarshaller.marshall(sheetDefinition.getTextBoxes(), TEXTBOXES_BINDING);
            protocolMarshaller.marshall(sheetDefinition.getLayouts(), LAYOUTS_BINDING);
            protocolMarshaller.marshall(sheetDefinition.getSheetControlLayouts(), SHEETCONTROLLAYOUTS_BINDING);
            protocolMarshaller.marshall((Object)sheetDefinition.getContentType(), CONTENTTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

