/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.SnapshotFile;
import com.amazonaws.services.quicksight.model.SnapshotJobS3Result;
import com.amazonaws.services.quicksight.model.transform.SnapshotJobResultFileGroupMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SnapshotJobResultFileGroup
implements Serializable,
Cloneable,
StructuredPojo {
    private List<SnapshotFile> files;
    private List<SnapshotJobS3Result> s3Results;

    public List<SnapshotFile> getFiles() {
        return this.files;
    }

    public void setFiles(Collection<SnapshotFile> files) {
        if (files == null) {
            this.files = null;
            return;
        }
        this.files = new ArrayList<SnapshotFile>(files);
    }

    public SnapshotJobResultFileGroup withFiles(SnapshotFile ... files) {
        if (this.files == null) {
            this.setFiles(new ArrayList<SnapshotFile>(files.length));
        }
        for (SnapshotFile ele : files) {
            this.files.add(ele);
        }
        return this;
    }

    public SnapshotJobResultFileGroup withFiles(Collection<SnapshotFile> files) {
        this.setFiles(files);
        return this;
    }

    public List<SnapshotJobS3Result> getS3Results() {
        return this.s3Results;
    }

    public void setS3Results(Collection<SnapshotJobS3Result> s3Results) {
        if (s3Results == null) {
            this.s3Results = null;
            return;
        }
        this.s3Results = new ArrayList<SnapshotJobS3Result>(s3Results);
    }

    public SnapshotJobResultFileGroup withS3Results(SnapshotJobS3Result ... s3Results) {
        if (this.s3Results == null) {
            this.setS3Results(new ArrayList<SnapshotJobS3Result>(s3Results.length));
        }
        for (SnapshotJobS3Result ele : s3Results) {
            this.s3Results.add(ele);
        }
        return this;
    }

    public SnapshotJobResultFileGroup withS3Results(Collection<SnapshotJobS3Result> s3Results) {
        this.setS3Results(s3Results);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFiles() != null) {
            sb.append("Files: ").append(this.getFiles()).append(",");
        }
        if (this.getS3Results() != null) {
            sb.append("S3Results: ").append(this.getS3Results());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotJobResultFileGroup)) {
            return false;
        }
        SnapshotJobResultFileGroup other = (SnapshotJobResultFileGroup)obj;
        if (other.getFiles() == null ^ this.getFiles() == null) {
            return false;
        }
        if (other.getFiles() != null && !other.getFiles().equals(this.getFiles())) {
            return false;
        }
        if (other.getS3Results() == null ^ this.getS3Results() == null) {
            return false;
        }
        return other.getS3Results() == null || other.getS3Results().equals(this.getS3Results());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFiles() == null ? 0 : this.getFiles().hashCode());
        hashCode = 31 * hashCode + (this.getS3Results() == null ? 0 : this.getS3Results().hashCode());
        return hashCode;
    }

    public SnapshotJobResultFileGroup clone() {
        try {
            return (SnapshotJobResultFileGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SnapshotJobResultFileGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

