/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.ThemeConfiguration;

@SdkInternalApi
public class ThemeConfigurationMarshaller {
    private static final MarshallingInfo<StructuredPojo> DATACOLORPALETTE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataColorPalette").build();
    private static final MarshallingInfo<StructuredPojo> UICOLORPALETTE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UIColorPalette").build();
    private static final MarshallingInfo<StructuredPojo> SHEET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Sheet").build();
    private static final MarshallingInfo<StructuredPojo> TYPOGRAPHY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Typography").build();
    private static final ThemeConfigurationMarshaller instance = new ThemeConfigurationMarshaller();

    public static ThemeConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(ThemeConfiguration themeConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (themeConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)themeConfiguration.getDataColorPalette(), DATACOLORPALETTE_BINDING);
            protocolMarshaller.marshall((Object)themeConfiguration.getUIColorPalette(), UICOLORPALETTE_BINDING);
            protocolMarshaller.marshall((Object)themeConfiguration.getSheet(), SHEET_BINDING);
            protocolMarshaller.marshall((Object)themeConfiguration.getTypography(), TYPOGRAPHY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

