/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.FieldSortOptions;
import com.amazonaws.services.quicksight.model.ItemsLimitConfiguration;
import com.amazonaws.services.quicksight.model.transform.WordCloudSortConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class WordCloudSortConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private ItemsLimitConfiguration categoryItemsLimit;
    private List<FieldSortOptions> categorySort;

    public void setCategoryItemsLimit(ItemsLimitConfiguration categoryItemsLimit) {
        this.categoryItemsLimit = categoryItemsLimit;
    }

    public ItemsLimitConfiguration getCategoryItemsLimit() {
        return this.categoryItemsLimit;
    }

    public WordCloudSortConfiguration withCategoryItemsLimit(ItemsLimitConfiguration categoryItemsLimit) {
        this.setCategoryItemsLimit(categoryItemsLimit);
        return this;
    }

    public List<FieldSortOptions> getCategorySort() {
        return this.categorySort;
    }

    public void setCategorySort(Collection<FieldSortOptions> categorySort) {
        if (categorySort == null) {
            this.categorySort = null;
            return;
        }
        this.categorySort = new ArrayList<FieldSortOptions>(categorySort);
    }

    public WordCloudSortConfiguration withCategorySort(FieldSortOptions ... categorySort) {
        if (this.categorySort == null) {
            this.setCategorySort(new ArrayList<FieldSortOptions>(categorySort.length));
        }
        for (FieldSortOptions ele : categorySort) {
            this.categorySort.add(ele);
        }
        return this;
    }

    public WordCloudSortConfiguration withCategorySort(Collection<FieldSortOptions> categorySort) {
        this.setCategorySort(categorySort);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCategoryItemsLimit() != null) {
            sb.append("CategoryItemsLimit: ").append(this.getCategoryItemsLimit()).append(",");
        }
        if (this.getCategorySort() != null) {
            sb.append("CategorySort: ").append(this.getCategorySort());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WordCloudSortConfiguration)) {
            return false;
        }
        WordCloudSortConfiguration other = (WordCloudSortConfiguration)obj;
        if (other.getCategoryItemsLimit() == null ^ this.getCategoryItemsLimit() == null) {
            return false;
        }
        if (other.getCategoryItemsLimit() != null && !other.getCategoryItemsLimit().equals(this.getCategoryItemsLimit())) {
            return false;
        }
        if (other.getCategorySort() == null ^ this.getCategorySort() == null) {
            return false;
        }
        return other.getCategorySort() == null || other.getCategorySort().equals(this.getCategorySort());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCategoryItemsLimit() == null ? 0 : this.getCategoryItemsLimit().hashCode());
        hashCode = 31 * hashCode + (this.getCategorySort() == null ? 0 : this.getCategorySort().hashCode());
        return hashCode;
    }

    public WordCloudSortConfiguration clone() {
        try {
            return (WordCloudSortConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WordCloudSortConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

