/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.quicksight.model.DataSourceSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SearchDataSourcesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<DataSourceSummary> dataSourceSummaries;
    private String nextToken;
    private Integer status;
    private String requestId;

    public List<DataSourceSummary> getDataSourceSummaries() {
        return this.dataSourceSummaries;
    }

    public void setDataSourceSummaries(Collection<DataSourceSummary> dataSourceSummaries) {
        if (dataSourceSummaries == null) {
            this.dataSourceSummaries = null;
            return;
        }
        this.dataSourceSummaries = new ArrayList<DataSourceSummary>(dataSourceSummaries);
    }

    public SearchDataSourcesResult withDataSourceSummaries(DataSourceSummary ... dataSourceSummaries) {
        if (this.dataSourceSummaries == null) {
            this.setDataSourceSummaries(new ArrayList<DataSourceSummary>(dataSourceSummaries.length));
        }
        for (DataSourceSummary ele : dataSourceSummaries) {
            this.dataSourceSummaries.add(ele);
        }
        return this;
    }

    public SearchDataSourcesResult withDataSourceSummaries(Collection<DataSourceSummary> dataSourceSummaries) {
        this.setDataSourceSummaries(dataSourceSummaries);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public SearchDataSourcesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getStatus() {
        return this.status;
    }

    public SearchDataSourcesResult withStatus(Integer status) {
        this.setStatus(status);
        return this;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public SearchDataSourcesResult withRequestId(String requestId) {
        this.setRequestId(requestId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDataSourceSummaries() != null) {
            sb.append("DataSourceSummaries: ").append(this.getDataSourceSummaries()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getRequestId() != null) {
            sb.append("RequestId: ").append(this.getRequestId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchDataSourcesResult)) {
            return false;
        }
        SearchDataSourcesResult other = (SearchDataSourcesResult)obj;
        if (other.getDataSourceSummaries() == null ^ this.getDataSourceSummaries() == null) {
            return false;
        }
        if (other.getDataSourceSummaries() != null && !other.getDataSourceSummaries().equals(this.getDataSourceSummaries())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getRequestId() == null ^ this.getRequestId() == null) {
            return false;
        }
        return other.getRequestId() == null || other.getRequestId().equals(this.getRequestId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDataSourceSummaries() == null ? 0 : this.getDataSourceSummaries().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getRequestId() == null ? 0 : this.getRequestId().hashCode());
        return hashCode;
    }

    public SearchDataSourcesResult clone() {
        try {
            return (SearchDataSourcesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

