/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.ColumnIdentifier;
import com.amazonaws.services.quicksight.model.SelectedFieldOptions;
import com.amazonaws.services.quicksight.model.transform.FilterOperationSelectedFieldsConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FilterOperationSelectedFieldsConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> selectedFields;
    private String selectedFieldOptions;
    private List<ColumnIdentifier> selectedColumns;

    public List<String> getSelectedFields() {
        return this.selectedFields;
    }

    public void setSelectedFields(Collection<String> selectedFields) {
        if (selectedFields == null) {
            this.selectedFields = null;
            return;
        }
        this.selectedFields = new ArrayList<String>(selectedFields);
    }

    public FilterOperationSelectedFieldsConfiguration withSelectedFields(String ... selectedFields) {
        if (this.selectedFields == null) {
            this.setSelectedFields(new ArrayList<String>(selectedFields.length));
        }
        for (String ele : selectedFields) {
            this.selectedFields.add(ele);
        }
        return this;
    }

    public FilterOperationSelectedFieldsConfiguration withSelectedFields(Collection<String> selectedFields) {
        this.setSelectedFields(selectedFields);
        return this;
    }

    public void setSelectedFieldOptions(String selectedFieldOptions) {
        this.selectedFieldOptions = selectedFieldOptions;
    }

    public String getSelectedFieldOptions() {
        return this.selectedFieldOptions;
    }

    public FilterOperationSelectedFieldsConfiguration withSelectedFieldOptions(String selectedFieldOptions) {
        this.setSelectedFieldOptions(selectedFieldOptions);
        return this;
    }

    public FilterOperationSelectedFieldsConfiguration withSelectedFieldOptions(SelectedFieldOptions selectedFieldOptions) {
        this.selectedFieldOptions = selectedFieldOptions.toString();
        return this;
    }

    public List<ColumnIdentifier> getSelectedColumns() {
        return this.selectedColumns;
    }

    public void setSelectedColumns(Collection<ColumnIdentifier> selectedColumns) {
        if (selectedColumns == null) {
            this.selectedColumns = null;
            return;
        }
        this.selectedColumns = new ArrayList<ColumnIdentifier>(selectedColumns);
    }

    public FilterOperationSelectedFieldsConfiguration withSelectedColumns(ColumnIdentifier ... selectedColumns) {
        if (this.selectedColumns == null) {
            this.setSelectedColumns(new ArrayList<ColumnIdentifier>(selectedColumns.length));
        }
        for (ColumnIdentifier ele : selectedColumns) {
            this.selectedColumns.add(ele);
        }
        return this;
    }

    public FilterOperationSelectedFieldsConfiguration withSelectedColumns(Collection<ColumnIdentifier> selectedColumns) {
        this.setSelectedColumns(selectedColumns);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSelectedFields() != null) {
            sb.append("SelectedFields: ").append(this.getSelectedFields()).append(",");
        }
        if (this.getSelectedFieldOptions() != null) {
            sb.append("SelectedFieldOptions: ").append(this.getSelectedFieldOptions()).append(",");
        }
        if (this.getSelectedColumns() != null) {
            sb.append("SelectedColumns: ").append(this.getSelectedColumns());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterOperationSelectedFieldsConfiguration)) {
            return false;
        }
        FilterOperationSelectedFieldsConfiguration other = (FilterOperationSelectedFieldsConfiguration)obj;
        if (other.getSelectedFields() == null ^ this.getSelectedFields() == null) {
            return false;
        }
        if (other.getSelectedFields() != null && !other.getSelectedFields().equals(this.getSelectedFields())) {
            return false;
        }
        if (other.getSelectedFieldOptions() == null ^ this.getSelectedFieldOptions() == null) {
            return false;
        }
        if (other.getSelectedFieldOptions() != null && !other.getSelectedFieldOptions().equals(this.getSelectedFieldOptions())) {
            return false;
        }
        if (other.getSelectedColumns() == null ^ this.getSelectedColumns() == null) {
            return false;
        }
        return other.getSelectedColumns() == null || other.getSelectedColumns().equals(this.getSelectedColumns());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSelectedFields() == null ? 0 : this.getSelectedFields().hashCode());
        hashCode = 31 * hashCode + (this.getSelectedFieldOptions() == null ? 0 : this.getSelectedFieldOptions().hashCode());
        hashCode = 31 * hashCode + (this.getSelectedColumns() == null ? 0 : this.getSelectedColumns().hashCode());
        return hashCode;
    }

    public FilterOperationSelectedFieldsConfiguration clone() {
        try {
            return (FilterOperationSelectedFieldsConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FilterOperationSelectedFieldsConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

