/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.AuthorSpecifiedAggregation;
import com.amazonaws.services.quicksight.model.CellValueSynonym;
import com.amazonaws.services.quicksight.model.ColumnDataRole;
import com.amazonaws.services.quicksight.model.ComparativeOrder;
import com.amazonaws.services.quicksight.model.DefaultAggregation;
import com.amazonaws.services.quicksight.model.DefaultFormatting;
import com.amazonaws.services.quicksight.model.SemanticType;
import com.amazonaws.services.quicksight.model.TopicTimeGranularity;
import com.amazonaws.services.quicksight.model.transform.TopicColumnMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TopicColumn
implements Serializable,
Cloneable,
StructuredPojo {
    private String columnName;
    private String columnFriendlyName;
    private String columnDescription;
    private List<String> columnSynonyms;
    private String columnDataRole;
    private String aggregation;
    private Boolean isIncludedInTopic;
    private Boolean disableIndexing;
    private ComparativeOrder comparativeOrder;
    private SemanticType semanticType;
    private String timeGranularity;
    private List<String> allowedAggregations;
    private List<String> notAllowedAggregations;
    private DefaultFormatting defaultFormatting;
    private Boolean neverAggregateInFilter;
    private List<CellValueSynonym> cellValueSynonyms;
    private Boolean nonAdditive;

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public TopicColumn withColumnName(String columnName) {
        this.setColumnName(columnName);
        return this;
    }

    public void setColumnFriendlyName(String columnFriendlyName) {
        this.columnFriendlyName = columnFriendlyName;
    }

    public String getColumnFriendlyName() {
        return this.columnFriendlyName;
    }

    public TopicColumn withColumnFriendlyName(String columnFriendlyName) {
        this.setColumnFriendlyName(columnFriendlyName);
        return this;
    }

    public void setColumnDescription(String columnDescription) {
        this.columnDescription = columnDescription;
    }

    public String getColumnDescription() {
        return this.columnDescription;
    }

    public TopicColumn withColumnDescription(String columnDescription) {
        this.setColumnDescription(columnDescription);
        return this;
    }

    public List<String> getColumnSynonyms() {
        return this.columnSynonyms;
    }

    public void setColumnSynonyms(Collection<String> columnSynonyms) {
        if (columnSynonyms == null) {
            this.columnSynonyms = null;
            return;
        }
        this.columnSynonyms = new ArrayList<String>(columnSynonyms);
    }

    public TopicColumn withColumnSynonyms(String ... columnSynonyms) {
        if (this.columnSynonyms == null) {
            this.setColumnSynonyms(new ArrayList<String>(columnSynonyms.length));
        }
        for (String ele : columnSynonyms) {
            this.columnSynonyms.add(ele);
        }
        return this;
    }

    public TopicColumn withColumnSynonyms(Collection<String> columnSynonyms) {
        this.setColumnSynonyms(columnSynonyms);
        return this;
    }

    public void setColumnDataRole(String columnDataRole) {
        this.columnDataRole = columnDataRole;
    }

    public String getColumnDataRole() {
        return this.columnDataRole;
    }

    public TopicColumn withColumnDataRole(String columnDataRole) {
        this.setColumnDataRole(columnDataRole);
        return this;
    }

    public TopicColumn withColumnDataRole(ColumnDataRole columnDataRole) {
        this.columnDataRole = columnDataRole.toString();
        return this;
    }

    public void setAggregation(String aggregation) {
        this.aggregation = aggregation;
    }

    public String getAggregation() {
        return this.aggregation;
    }

    public TopicColumn withAggregation(String aggregation) {
        this.setAggregation(aggregation);
        return this;
    }

    public TopicColumn withAggregation(DefaultAggregation aggregation) {
        this.aggregation = aggregation.toString();
        return this;
    }

    public void setIsIncludedInTopic(Boolean isIncludedInTopic) {
        this.isIncludedInTopic = isIncludedInTopic;
    }

    public Boolean getIsIncludedInTopic() {
        return this.isIncludedInTopic;
    }

    public TopicColumn withIsIncludedInTopic(Boolean isIncludedInTopic) {
        this.setIsIncludedInTopic(isIncludedInTopic);
        return this;
    }

    public Boolean isIncludedInTopic() {
        return this.isIncludedInTopic;
    }

    public void setDisableIndexing(Boolean disableIndexing) {
        this.disableIndexing = disableIndexing;
    }

    public Boolean getDisableIndexing() {
        return this.disableIndexing;
    }

    public TopicColumn withDisableIndexing(Boolean disableIndexing) {
        this.setDisableIndexing(disableIndexing);
        return this;
    }

    public Boolean isDisableIndexing() {
        return this.disableIndexing;
    }

    public void setComparativeOrder(ComparativeOrder comparativeOrder) {
        this.comparativeOrder = comparativeOrder;
    }

    public ComparativeOrder getComparativeOrder() {
        return this.comparativeOrder;
    }

    public TopicColumn withComparativeOrder(ComparativeOrder comparativeOrder) {
        this.setComparativeOrder(comparativeOrder);
        return this;
    }

    public void setSemanticType(SemanticType semanticType) {
        this.semanticType = semanticType;
    }

    public SemanticType getSemanticType() {
        return this.semanticType;
    }

    public TopicColumn withSemanticType(SemanticType semanticType) {
        this.setSemanticType(semanticType);
        return this;
    }

    public void setTimeGranularity(String timeGranularity) {
        this.timeGranularity = timeGranularity;
    }

    public String getTimeGranularity() {
        return this.timeGranularity;
    }

    public TopicColumn withTimeGranularity(String timeGranularity) {
        this.setTimeGranularity(timeGranularity);
        return this;
    }

    public TopicColumn withTimeGranularity(TopicTimeGranularity timeGranularity) {
        this.timeGranularity = timeGranularity.toString();
        return this;
    }

    public List<String> getAllowedAggregations() {
        return this.allowedAggregations;
    }

    public void setAllowedAggregations(Collection<String> allowedAggregations) {
        if (allowedAggregations == null) {
            this.allowedAggregations = null;
            return;
        }
        this.allowedAggregations = new ArrayList<String>(allowedAggregations);
    }

    public TopicColumn withAllowedAggregations(String ... allowedAggregations) {
        if (this.allowedAggregations == null) {
            this.setAllowedAggregations(new ArrayList<String>(allowedAggregations.length));
        }
        for (String ele : allowedAggregations) {
            this.allowedAggregations.add(ele);
        }
        return this;
    }

    public TopicColumn withAllowedAggregations(Collection<String> allowedAggregations) {
        this.setAllowedAggregations(allowedAggregations);
        return this;
    }

    public TopicColumn withAllowedAggregations(AuthorSpecifiedAggregation ... allowedAggregations) {
        ArrayList<String> allowedAggregationsCopy = new ArrayList<String>(allowedAggregations.length);
        for (AuthorSpecifiedAggregation value : allowedAggregations) {
            allowedAggregationsCopy.add(value.toString());
        }
        if (this.getAllowedAggregations() == null) {
            this.setAllowedAggregations(allowedAggregationsCopy);
        } else {
            this.getAllowedAggregations().addAll(allowedAggregationsCopy);
        }
        return this;
    }

    public List<String> getNotAllowedAggregations() {
        return this.notAllowedAggregations;
    }

    public void setNotAllowedAggregations(Collection<String> notAllowedAggregations) {
        if (notAllowedAggregations == null) {
            this.notAllowedAggregations = null;
            return;
        }
        this.notAllowedAggregations = new ArrayList<String>(notAllowedAggregations);
    }

    public TopicColumn withNotAllowedAggregations(String ... notAllowedAggregations) {
        if (this.notAllowedAggregations == null) {
            this.setNotAllowedAggregations(new ArrayList<String>(notAllowedAggregations.length));
        }
        for (String ele : notAllowedAggregations) {
            this.notAllowedAggregations.add(ele);
        }
        return this;
    }

    public TopicColumn withNotAllowedAggregations(Collection<String> notAllowedAggregations) {
        this.setNotAllowedAggregations(notAllowedAggregations);
        return this;
    }

    public TopicColumn withNotAllowedAggregations(AuthorSpecifiedAggregation ... notAllowedAggregations) {
        ArrayList<String> notAllowedAggregationsCopy = new ArrayList<String>(notAllowedAggregations.length);
        for (AuthorSpecifiedAggregation value : notAllowedAggregations) {
            notAllowedAggregationsCopy.add(value.toString());
        }
        if (this.getNotAllowedAggregations() == null) {
            this.setNotAllowedAggregations(notAllowedAggregationsCopy);
        } else {
            this.getNotAllowedAggregations().addAll(notAllowedAggregationsCopy);
        }
        return this;
    }

    public void setDefaultFormatting(DefaultFormatting defaultFormatting) {
        this.defaultFormatting = defaultFormatting;
    }

    public DefaultFormatting getDefaultFormatting() {
        return this.defaultFormatting;
    }

    public TopicColumn withDefaultFormatting(DefaultFormatting defaultFormatting) {
        this.setDefaultFormatting(defaultFormatting);
        return this;
    }

    public void setNeverAggregateInFilter(Boolean neverAggregateInFilter) {
        this.neverAggregateInFilter = neverAggregateInFilter;
    }

    public Boolean getNeverAggregateInFilter() {
        return this.neverAggregateInFilter;
    }

    public TopicColumn withNeverAggregateInFilter(Boolean neverAggregateInFilter) {
        this.setNeverAggregateInFilter(neverAggregateInFilter);
        return this;
    }

    public Boolean isNeverAggregateInFilter() {
        return this.neverAggregateInFilter;
    }

    public List<CellValueSynonym> getCellValueSynonyms() {
        return this.cellValueSynonyms;
    }

    public void setCellValueSynonyms(Collection<CellValueSynonym> cellValueSynonyms) {
        if (cellValueSynonyms == null) {
            this.cellValueSynonyms = null;
            return;
        }
        this.cellValueSynonyms = new ArrayList<CellValueSynonym>(cellValueSynonyms);
    }

    public TopicColumn withCellValueSynonyms(CellValueSynonym ... cellValueSynonyms) {
        if (this.cellValueSynonyms == null) {
            this.setCellValueSynonyms(new ArrayList<CellValueSynonym>(cellValueSynonyms.length));
        }
        for (CellValueSynonym ele : cellValueSynonyms) {
            this.cellValueSynonyms.add(ele);
        }
        return this;
    }

    public TopicColumn withCellValueSynonyms(Collection<CellValueSynonym> cellValueSynonyms) {
        this.setCellValueSynonyms(cellValueSynonyms);
        return this;
    }

    public void setNonAdditive(Boolean nonAdditive) {
        this.nonAdditive = nonAdditive;
    }

    public Boolean getNonAdditive() {
        return this.nonAdditive;
    }

    public TopicColumn withNonAdditive(Boolean nonAdditive) {
        this.setNonAdditive(nonAdditive);
        return this;
    }

    public Boolean isNonAdditive() {
        return this.nonAdditive;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getColumnName() != null) {
            sb.append("ColumnName: ").append(this.getColumnName()).append(",");
        }
        if (this.getColumnFriendlyName() != null) {
            sb.append("ColumnFriendlyName: ").append(this.getColumnFriendlyName()).append(",");
        }
        if (this.getColumnDescription() != null) {
            sb.append("ColumnDescription: ").append(this.getColumnDescription()).append(",");
        }
        if (this.getColumnSynonyms() != null) {
            sb.append("ColumnSynonyms: ").append(this.getColumnSynonyms()).append(",");
        }
        if (this.getColumnDataRole() != null) {
            sb.append("ColumnDataRole: ").append(this.getColumnDataRole()).append(",");
        }
        if (this.getAggregation() != null) {
            sb.append("Aggregation: ").append(this.getAggregation()).append(",");
        }
        if (this.getIsIncludedInTopic() != null) {
            sb.append("IsIncludedInTopic: ").append(this.getIsIncludedInTopic()).append(",");
        }
        if (this.getDisableIndexing() != null) {
            sb.append("DisableIndexing: ").append(this.getDisableIndexing()).append(",");
        }
        if (this.getComparativeOrder() != null) {
            sb.append("ComparativeOrder: ").append(this.getComparativeOrder()).append(",");
        }
        if (this.getSemanticType() != null) {
            sb.append("SemanticType: ").append(this.getSemanticType()).append(",");
        }
        if (this.getTimeGranularity() != null) {
            sb.append("TimeGranularity: ").append(this.getTimeGranularity()).append(",");
        }
        if (this.getAllowedAggregations() != null) {
            sb.append("AllowedAggregations: ").append(this.getAllowedAggregations()).append(",");
        }
        if (this.getNotAllowedAggregations() != null) {
            sb.append("NotAllowedAggregations: ").append(this.getNotAllowedAggregations()).append(",");
        }
        if (this.getDefaultFormatting() != null) {
            sb.append("DefaultFormatting: ").append(this.getDefaultFormatting()).append(",");
        }
        if (this.getNeverAggregateInFilter() != null) {
            sb.append("NeverAggregateInFilter: ").append(this.getNeverAggregateInFilter()).append(",");
        }
        if (this.getCellValueSynonyms() != null) {
            sb.append("CellValueSynonyms: ").append(this.getCellValueSynonyms()).append(",");
        }
        if (this.getNonAdditive() != null) {
            sb.append("NonAdditive: ").append(this.getNonAdditive());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicColumn)) {
            return false;
        }
        TopicColumn other = (TopicColumn)obj;
        if (other.getColumnName() == null ^ this.getColumnName() == null) {
            return false;
        }
        if (other.getColumnName() != null && !other.getColumnName().equals(this.getColumnName())) {
            return false;
        }
        if (other.getColumnFriendlyName() == null ^ this.getColumnFriendlyName() == null) {
            return false;
        }
        if (other.getColumnFriendlyName() != null && !other.getColumnFriendlyName().equals(this.getColumnFriendlyName())) {
            return false;
        }
        if (other.getColumnDescription() == null ^ this.getColumnDescription() == null) {
            return false;
        }
        if (other.getColumnDescription() != null && !other.getColumnDescription().equals(this.getColumnDescription())) {
            return false;
        }
        if (other.getColumnSynonyms() == null ^ this.getColumnSynonyms() == null) {
            return false;
        }
        if (other.getColumnSynonyms() != null && !other.getColumnSynonyms().equals(this.getColumnSynonyms())) {
            return false;
        }
        if (other.getColumnDataRole() == null ^ this.getColumnDataRole() == null) {
            return false;
        }
        if (other.getColumnDataRole() != null && !other.getColumnDataRole().equals(this.getColumnDataRole())) {
            return false;
        }
        if (other.getAggregation() == null ^ this.getAggregation() == null) {
            return false;
        }
        if (other.getAggregation() != null && !other.getAggregation().equals(this.getAggregation())) {
            return false;
        }
        if (other.getIsIncludedInTopic() == null ^ this.getIsIncludedInTopic() == null) {
            return false;
        }
        if (other.getIsIncludedInTopic() != null && !other.getIsIncludedInTopic().equals(this.getIsIncludedInTopic())) {
            return false;
        }
        if (other.getDisableIndexing() == null ^ this.getDisableIndexing() == null) {
            return false;
        }
        if (other.getDisableIndexing() != null && !other.getDisableIndexing().equals(this.getDisableIndexing())) {
            return false;
        }
        if (other.getComparativeOrder() == null ^ this.getComparativeOrder() == null) {
            return false;
        }
        if (other.getComparativeOrder() != null && !other.getComparativeOrder().equals(this.getComparativeOrder())) {
            return false;
        }
        if (other.getSemanticType() == null ^ this.getSemanticType() == null) {
            return false;
        }
        if (other.getSemanticType() != null && !other.getSemanticType().equals(this.getSemanticType())) {
            return false;
        }
        if (other.getTimeGranularity() == null ^ this.getTimeGranularity() == null) {
            return false;
        }
        if (other.getTimeGranularity() != null && !other.getTimeGranularity().equals(this.getTimeGranularity())) {
            return false;
        }
        if (other.getAllowedAggregations() == null ^ this.getAllowedAggregations() == null) {
            return false;
        }
        if (other.getAllowedAggregations() != null && !other.getAllowedAggregations().equals(this.getAllowedAggregations())) {
            return false;
        }
        if (other.getNotAllowedAggregations() == null ^ this.getNotAllowedAggregations() == null) {
            return false;
        }
        if (other.getNotAllowedAggregations() != null && !other.getNotAllowedAggregations().equals(this.getNotAllowedAggregations())) {
            return false;
        }
        if (other.getDefaultFormatting() == null ^ this.getDefaultFormatting() == null) {
            return false;
        }
        if (other.getDefaultFormatting() != null && !other.getDefaultFormatting().equals(this.getDefaultFormatting())) {
            return false;
        }
        if (other.getNeverAggregateInFilter() == null ^ this.getNeverAggregateInFilter() == null) {
            return false;
        }
        if (other.getNeverAggregateInFilter() != null && !other.getNeverAggregateInFilter().equals(this.getNeverAggregateInFilter())) {
            return false;
        }
        if (other.getCellValueSynonyms() == null ^ this.getCellValueSynonyms() == null) {
            return false;
        }
        if (other.getCellValueSynonyms() != null && !other.getCellValueSynonyms().equals(this.getCellValueSynonyms())) {
            return false;
        }
        if (other.getNonAdditive() == null ^ this.getNonAdditive() == null) {
            return false;
        }
        return other.getNonAdditive() == null || other.getNonAdditive().equals(this.getNonAdditive());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getColumnName() == null ? 0 : this.getColumnName().hashCode());
        hashCode = 31 * hashCode + (this.getColumnFriendlyName() == null ? 0 : this.getColumnFriendlyName().hashCode());
        hashCode = 31 * hashCode + (this.getColumnDescription() == null ? 0 : this.getColumnDescription().hashCode());
        hashCode = 31 * hashCode + (this.getColumnSynonyms() == null ? 0 : this.getColumnSynonyms().hashCode());
        hashCode = 31 * hashCode + (this.getColumnDataRole() == null ? 0 : this.getColumnDataRole().hashCode());
        hashCode = 31 * hashCode + (this.getAggregation() == null ? 0 : this.getAggregation().hashCode());
        hashCode = 31 * hashCode + (this.getIsIncludedInTopic() == null ? 0 : this.getIsIncludedInTopic().hashCode());
        hashCode = 31 * hashCode + (this.getDisableIndexing() == null ? 0 : this.getDisableIndexing().hashCode());
        hashCode = 31 * hashCode + (this.getComparativeOrder() == null ? 0 : this.getComparativeOrder().hashCode());
        hashCode = 31 * hashCode + (this.getSemanticType() == null ? 0 : this.getSemanticType().hashCode());
        hashCode = 31 * hashCode + (this.getTimeGranularity() == null ? 0 : this.getTimeGranularity().hashCode());
        hashCode = 31 * hashCode + (this.getAllowedAggregations() == null ? 0 : this.getAllowedAggregations().hashCode());
        hashCode = 31 * hashCode + (this.getNotAllowedAggregations() == null ? 0 : this.getNotAllowedAggregations().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultFormatting() == null ? 0 : this.getDefaultFormatting().hashCode());
        hashCode = 31 * hashCode + (this.getNeverAggregateInFilter() == null ? 0 : this.getNeverAggregateInFilter().hashCode());
        hashCode = 31 * hashCode + (this.getCellValueSynonyms() == null ? 0 : this.getCellValueSynonyms().hashCode());
        hashCode = 31 * hashCode + (this.getNonAdditive() == null ? 0 : this.getNonAdditive().hashCode());
        return hashCode;
    }

    public TopicColumn clone() {
        try {
            return (TopicColumn)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TopicColumnMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

