/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.NamedFilterAggType;
import com.amazonaws.services.quicksight.model.TopicRangeFilterConstant;
import com.amazonaws.services.quicksight.model.transform.TopicNumericRangeFilterMarshaller;
import java.io.Serializable;

public class TopicNumericRangeFilter
implements Serializable,
Cloneable,
StructuredPojo {
    private Boolean inclusive;
    private TopicRangeFilterConstant constant;
    private String aggregation;

    public void setInclusive(Boolean inclusive) {
        this.inclusive = inclusive;
    }

    public Boolean getInclusive() {
        return this.inclusive;
    }

    public TopicNumericRangeFilter withInclusive(Boolean inclusive) {
        this.setInclusive(inclusive);
        return this;
    }

    public Boolean isInclusive() {
        return this.inclusive;
    }

    public void setConstant(TopicRangeFilterConstant constant) {
        this.constant = constant;
    }

    public TopicRangeFilterConstant getConstant() {
        return this.constant;
    }

    public TopicNumericRangeFilter withConstant(TopicRangeFilterConstant constant) {
        this.setConstant(constant);
        return this;
    }

    public void setAggregation(String aggregation) {
        this.aggregation = aggregation;
    }

    public String getAggregation() {
        return this.aggregation;
    }

    public TopicNumericRangeFilter withAggregation(String aggregation) {
        this.setAggregation(aggregation);
        return this;
    }

    public TopicNumericRangeFilter withAggregation(NamedFilterAggType aggregation) {
        this.aggregation = aggregation.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInclusive() != null) {
            sb.append("Inclusive: ").append(this.getInclusive()).append(",");
        }
        if (this.getConstant() != null) {
            sb.append("Constant: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getAggregation() != null) {
            sb.append("Aggregation: ").append(this.getAggregation());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicNumericRangeFilter)) {
            return false;
        }
        TopicNumericRangeFilter other = (TopicNumericRangeFilter)obj;
        if (other.getInclusive() == null ^ this.getInclusive() == null) {
            return false;
        }
        if (other.getInclusive() != null && !other.getInclusive().equals(this.getInclusive())) {
            return false;
        }
        if (other.getConstant() == null ^ this.getConstant() == null) {
            return false;
        }
        if (other.getConstant() != null && !other.getConstant().equals(this.getConstant())) {
            return false;
        }
        if (other.getAggregation() == null ^ this.getAggregation() == null) {
            return false;
        }
        return other.getAggregation() == null || other.getAggregation().equals(this.getAggregation());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInclusive() == null ? 0 : this.getInclusive().hashCode());
        hashCode = 31 * hashCode + (this.getConstant() == null ? 0 : this.getConstant().hashCode());
        hashCode = 31 * hashCode + (this.getAggregation() == null ? 0 : this.getAggregation().hashCode());
        return hashCode;
    }

    public TopicNumericRangeFilter clone() {
        try {
            return (TopicNumericRangeFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TopicNumericRangeFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

