/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.transform.ResourcePermissionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ResourcePermission
implements Serializable,
Cloneable,
StructuredPojo {
    private String principal;
    private List<String> actions;

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public ResourcePermission withPrincipal(String principal) {
        this.setPrincipal(principal);
        return this;
    }

    public List<String> getActions() {
        return this.actions;
    }

    public void setActions(Collection<String> actions) {
        if (actions == null) {
            this.actions = null;
            return;
        }
        this.actions = new ArrayList<String>(actions);
    }

    public ResourcePermission withActions(String ... actions) {
        if (this.actions == null) {
            this.setActions(new ArrayList<String>(actions.length));
        }
        for (String ele : actions) {
            this.actions.add(ele);
        }
        return this;
    }

    public ResourcePermission withActions(Collection<String> actions) {
        this.setActions(actions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPrincipal() != null) {
            sb.append("Principal: ").append(this.getPrincipal()).append(",");
        }
        if (this.getActions() != null) {
            sb.append("Actions: ").append(this.getActions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourcePermission)) {
            return false;
        }
        ResourcePermission other = (ResourcePermission)obj;
        if (other.getPrincipal() == null ^ this.getPrincipal() == null) {
            return false;
        }
        if (other.getPrincipal() != null && !other.getPrincipal().equals(this.getPrincipal())) {
            return false;
        }
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        return other.getActions() == null || other.getActions().equals(this.getActions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPrincipal() == null ? 0 : this.getPrincipal().hashCode());
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        return hashCode;
    }

    public ResourcePermission clone() {
        try {
            return (ResourcePermission)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourcePermissionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

