/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.DataLabelContent;
import com.amazonaws.services.quicksight.model.DataLabelOverlap;
import com.amazonaws.services.quicksight.model.DataLabelPosition;
import com.amazonaws.services.quicksight.model.DataLabelType;
import com.amazonaws.services.quicksight.model.FontConfiguration;
import com.amazonaws.services.quicksight.model.Visibility;
import com.amazonaws.services.quicksight.model.transform.DataLabelOptionsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DataLabelOptions
implements Serializable,
Cloneable,
StructuredPojo {
    private String visibility;
    private String categoryLabelVisibility;
    private String measureLabelVisibility;
    private List<DataLabelType> dataLabelTypes;
    private String position;
    private String labelContent;
    private FontConfiguration labelFontConfiguration;
    private String labelColor;
    private String overlap;

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public DataLabelOptions withVisibility(String visibility) {
        this.setVisibility(visibility);
        return this;
    }

    public DataLabelOptions withVisibility(Visibility visibility) {
        this.visibility = visibility.toString();
        return this;
    }

    public void setCategoryLabelVisibility(String categoryLabelVisibility) {
        this.categoryLabelVisibility = categoryLabelVisibility;
    }

    public String getCategoryLabelVisibility() {
        return this.categoryLabelVisibility;
    }

    public DataLabelOptions withCategoryLabelVisibility(String categoryLabelVisibility) {
        this.setCategoryLabelVisibility(categoryLabelVisibility);
        return this;
    }

    public DataLabelOptions withCategoryLabelVisibility(Visibility categoryLabelVisibility) {
        this.categoryLabelVisibility = categoryLabelVisibility.toString();
        return this;
    }

    public void setMeasureLabelVisibility(String measureLabelVisibility) {
        this.measureLabelVisibility = measureLabelVisibility;
    }

    public String getMeasureLabelVisibility() {
        return this.measureLabelVisibility;
    }

    public DataLabelOptions withMeasureLabelVisibility(String measureLabelVisibility) {
        this.setMeasureLabelVisibility(measureLabelVisibility);
        return this;
    }

    public DataLabelOptions withMeasureLabelVisibility(Visibility measureLabelVisibility) {
        this.measureLabelVisibility = measureLabelVisibility.toString();
        return this;
    }

    public List<DataLabelType> getDataLabelTypes() {
        return this.dataLabelTypes;
    }

    public void setDataLabelTypes(Collection<DataLabelType> dataLabelTypes) {
        if (dataLabelTypes == null) {
            this.dataLabelTypes = null;
            return;
        }
        this.dataLabelTypes = new ArrayList<DataLabelType>(dataLabelTypes);
    }

    public DataLabelOptions withDataLabelTypes(DataLabelType ... dataLabelTypes) {
        if (this.dataLabelTypes == null) {
            this.setDataLabelTypes(new ArrayList<DataLabelType>(dataLabelTypes.length));
        }
        for (DataLabelType ele : dataLabelTypes) {
            this.dataLabelTypes.add(ele);
        }
        return this;
    }

    public DataLabelOptions withDataLabelTypes(Collection<DataLabelType> dataLabelTypes) {
        this.setDataLabelTypes(dataLabelTypes);
        return this;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String getPosition() {
        return this.position;
    }

    public DataLabelOptions withPosition(String position) {
        this.setPosition(position);
        return this;
    }

    public DataLabelOptions withPosition(DataLabelPosition position) {
        this.position = position.toString();
        return this;
    }

    public void setLabelContent(String labelContent) {
        this.labelContent = labelContent;
    }

    public String getLabelContent() {
        return this.labelContent;
    }

    public DataLabelOptions withLabelContent(String labelContent) {
        this.setLabelContent(labelContent);
        return this;
    }

    public DataLabelOptions withLabelContent(DataLabelContent labelContent) {
        this.labelContent = labelContent.toString();
        return this;
    }

    public void setLabelFontConfiguration(FontConfiguration labelFontConfiguration) {
        this.labelFontConfiguration = labelFontConfiguration;
    }

    public FontConfiguration getLabelFontConfiguration() {
        return this.labelFontConfiguration;
    }

    public DataLabelOptions withLabelFontConfiguration(FontConfiguration labelFontConfiguration) {
        this.setLabelFontConfiguration(labelFontConfiguration);
        return this;
    }

    public void setLabelColor(String labelColor) {
        this.labelColor = labelColor;
    }

    public String getLabelColor() {
        return this.labelColor;
    }

    public DataLabelOptions withLabelColor(String labelColor) {
        this.setLabelColor(labelColor);
        return this;
    }

    public void setOverlap(String overlap) {
        this.overlap = overlap;
    }

    public String getOverlap() {
        return this.overlap;
    }

    public DataLabelOptions withOverlap(String overlap) {
        this.setOverlap(overlap);
        return this;
    }

    public DataLabelOptions withOverlap(DataLabelOverlap overlap) {
        this.overlap = overlap.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVisibility() != null) {
            sb.append("Visibility: ").append(this.getVisibility()).append(",");
        }
        if (this.getCategoryLabelVisibility() != null) {
            sb.append("CategoryLabelVisibility: ").append(this.getCategoryLabelVisibility()).append(",");
        }
        if (this.getMeasureLabelVisibility() != null) {
            sb.append("MeasureLabelVisibility: ").append(this.getMeasureLabelVisibility()).append(",");
        }
        if (this.getDataLabelTypes() != null) {
            sb.append("DataLabelTypes: ").append(this.getDataLabelTypes()).append(",");
        }
        if (this.getPosition() != null) {
            sb.append("Position: ").append(this.getPosition()).append(",");
        }
        if (this.getLabelContent() != null) {
            sb.append("LabelContent: ").append(this.getLabelContent()).append(",");
        }
        if (this.getLabelFontConfiguration() != null) {
            sb.append("LabelFontConfiguration: ").append(this.getLabelFontConfiguration()).append(",");
        }
        if (this.getLabelColor() != null) {
            sb.append("LabelColor: ").append(this.getLabelColor()).append(",");
        }
        if (this.getOverlap() != null) {
            sb.append("Overlap: ").append(this.getOverlap());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLabelOptions)) {
            return false;
        }
        DataLabelOptions other = (DataLabelOptions)obj;
        if (other.getVisibility() == null ^ this.getVisibility() == null) {
            return false;
        }
        if (other.getVisibility() != null && !other.getVisibility().equals(this.getVisibility())) {
            return false;
        }
        if (other.getCategoryLabelVisibility() == null ^ this.getCategoryLabelVisibility() == null) {
            return false;
        }
        if (other.getCategoryLabelVisibility() != null && !other.getCategoryLabelVisibility().equals(this.getCategoryLabelVisibility())) {
            return false;
        }
        if (other.getMeasureLabelVisibility() == null ^ this.getMeasureLabelVisibility() == null) {
            return false;
        }
        if (other.getMeasureLabelVisibility() != null && !other.getMeasureLabelVisibility().equals(this.getMeasureLabelVisibility())) {
            return false;
        }
        if (other.getDataLabelTypes() == null ^ this.getDataLabelTypes() == null) {
            return false;
        }
        if (other.getDataLabelTypes() != null && !other.getDataLabelTypes().equals(this.getDataLabelTypes())) {
            return false;
        }
        if (other.getPosition() == null ^ this.getPosition() == null) {
            return false;
        }
        if (other.getPosition() != null && !other.getPosition().equals(this.getPosition())) {
            return false;
        }
        if (other.getLabelContent() == null ^ this.getLabelContent() == null) {
            return false;
        }
        if (other.getLabelContent() != null && !other.getLabelContent().equals(this.getLabelContent())) {
            return false;
        }
        if (other.getLabelFontConfiguration() == null ^ this.getLabelFontConfiguration() == null) {
            return false;
        }
        if (other.getLabelFontConfiguration() != null && !other.getLabelFontConfiguration().equals(this.getLabelFontConfiguration())) {
            return false;
        }
        if (other.getLabelColor() == null ^ this.getLabelColor() == null) {
            return false;
        }
        if (other.getLabelColor() != null && !other.getLabelColor().equals(this.getLabelColor())) {
            return false;
        }
        if (other.getOverlap() == null ^ this.getOverlap() == null) {
            return false;
        }
        return other.getOverlap() == null || other.getOverlap().equals(this.getOverlap());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVisibility() == null ? 0 : this.getVisibility().hashCode());
        hashCode = 31 * hashCode + (this.getCategoryLabelVisibility() == null ? 0 : this.getCategoryLabelVisibility().hashCode());
        hashCode = 31 * hashCode + (this.getMeasureLabelVisibility() == null ? 0 : this.getMeasureLabelVisibility().hashCode());
        hashCode = 31 * hashCode + (this.getDataLabelTypes() == null ? 0 : this.getDataLabelTypes().hashCode());
        hashCode = 31 * hashCode + (this.getPosition() == null ? 0 : this.getPosition().hashCode());
        hashCode = 31 * hashCode + (this.getLabelContent() == null ? 0 : this.getLabelContent().hashCode());
        hashCode = 31 * hashCode + (this.getLabelFontConfiguration() == null ? 0 : this.getLabelFontConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getLabelColor() == null ? 0 : this.getLabelColor().hashCode());
        hashCode = 31 * hashCode + (this.getOverlap() == null ? 0 : this.getOverlap().hashCode());
        return hashCode;
    }

    public DataLabelOptions clone() {
        try {
            return (DataLabelOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DataLabelOptionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

