/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.DataSetReference;
import com.amazonaws.services.quicksight.model.transform.AnalysisSourceTemplateMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AnalysisSourceTemplate
implements Serializable,
Cloneable,
StructuredPojo {
    private List<DataSetReference> dataSetReferences;
    private String arn;

    public List<DataSetReference> getDataSetReferences() {
        return this.dataSetReferences;
    }

    public void setDataSetReferences(Collection<DataSetReference> dataSetReferences) {
        if (dataSetReferences == null) {
            this.dataSetReferences = null;
            return;
        }
        this.dataSetReferences = new ArrayList<DataSetReference>(dataSetReferences);
    }

    public AnalysisSourceTemplate withDataSetReferences(DataSetReference ... dataSetReferences) {
        if (this.dataSetReferences == null) {
            this.setDataSetReferences(new ArrayList<DataSetReference>(dataSetReferences.length));
        }
        for (DataSetReference ele : dataSetReferences) {
            this.dataSetReferences.add(ele);
        }
        return this;
    }

    public AnalysisSourceTemplate withDataSetReferences(Collection<DataSetReference> dataSetReferences) {
        this.setDataSetReferences(dataSetReferences);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public AnalysisSourceTemplate withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDataSetReferences() != null) {
            sb.append("DataSetReferences: ").append(this.getDataSetReferences()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisSourceTemplate)) {
            return false;
        }
        AnalysisSourceTemplate other = (AnalysisSourceTemplate)obj;
        if (other.getDataSetReferences() == null ^ this.getDataSetReferences() == null) {
            return false;
        }
        if (other.getDataSetReferences() != null && !other.getDataSetReferences().equals(this.getDataSetReferences())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        return other.getArn() == null || other.getArn().equals(this.getArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDataSetReferences() == null ? 0 : this.getDataSetReferences().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        return hashCode;
    }

    public AnalysisSourceTemplate clone() {
        try {
            return (AnalysisSourceTemplate)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AnalysisSourceTemplateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

