/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.quicksight.model.DataSource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListDataSourcesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<DataSource> dataSources;
    private String nextToken;
    private String requestId;
    private Integer status;

    public List<DataSource> getDataSources() {
        return this.dataSources;
    }

    public void setDataSources(Collection<DataSource> dataSources) {
        if (dataSources == null) {
            this.dataSources = null;
            return;
        }
        this.dataSources = new ArrayList<DataSource>(dataSources);
    }

    public ListDataSourcesResult withDataSources(DataSource ... dataSources) {
        if (this.dataSources == null) {
            this.setDataSources(new ArrayList<DataSource>(dataSources.length));
        }
        for (DataSource ele : dataSources) {
            this.dataSources.add(ele);
        }
        return this;
    }

    public ListDataSourcesResult withDataSources(Collection<DataSource> dataSources) {
        this.setDataSources(dataSources);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListDataSourcesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public ListDataSourcesResult withRequestId(String requestId) {
        this.setRequestId(requestId);
        return this;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getStatus() {
        return this.status;
    }

    public ListDataSourcesResult withStatus(Integer status) {
        this.setStatus(status);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDataSources() != null) {
            sb.append("DataSources: ").append(this.getDataSources()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getRequestId() != null) {
            sb.append("RequestId: ").append(this.getRequestId()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataSourcesResult)) {
            return false;
        }
        ListDataSourcesResult other = (ListDataSourcesResult)obj;
        if (other.getDataSources() == null ^ this.getDataSources() == null) {
            return false;
        }
        if (other.getDataSources() != null && !other.getDataSources().equals(this.getDataSources())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getRequestId() == null ^ this.getRequestId() == null) {
            return false;
        }
        if (other.getRequestId() != null && !other.getRequestId().equals(this.getRequestId())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        return other.getStatus() == null || other.getStatus().equals(this.getStatus());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDataSources() == null ? 0 : this.getDataSources().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getRequestId() == null ? 0 : this.getRequestId().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        return hashCode;
    }

    public ListDataSourcesResult clone() {
        try {
            return (ListDataSourcesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

