/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.DataSetConfiguration;
import com.amazonaws.services.quicksight.model.ResourceStatus;
import com.amazonaws.services.quicksight.model.TemplateError;
import com.amazonaws.services.quicksight.model.transform.TemplateVersionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class TemplateVersion
implements Serializable,
Cloneable,
StructuredPojo {
    private Date createdTime;
    private List<TemplateError> errors;
    private Long versionNumber;
    private String status;
    private List<DataSetConfiguration> dataSetConfigurations;
    private String description;
    private String sourceEntityArn;

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public TemplateVersion withCreatedTime(Date createdTime) {
        this.setCreatedTime(createdTime);
        return this;
    }

    public List<TemplateError> getErrors() {
        return this.errors;
    }

    public void setErrors(Collection<TemplateError> errors) {
        if (errors == null) {
            this.errors = null;
            return;
        }
        this.errors = new ArrayList<TemplateError>(errors);
    }

    public TemplateVersion withErrors(TemplateError ... errors) {
        if (this.errors == null) {
            this.setErrors(new ArrayList<TemplateError>(errors.length));
        }
        for (TemplateError ele : errors) {
            this.errors.add(ele);
        }
        return this;
    }

    public TemplateVersion withErrors(Collection<TemplateError> errors) {
        this.setErrors(errors);
        return this;
    }

    public void setVersionNumber(Long versionNumber) {
        this.versionNumber = versionNumber;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public TemplateVersion withVersionNumber(Long versionNumber) {
        this.setVersionNumber(versionNumber);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public TemplateVersion withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public TemplateVersion withStatus(ResourceStatus status) {
        this.status = status.toString();
        return this;
    }

    public List<DataSetConfiguration> getDataSetConfigurations() {
        return this.dataSetConfigurations;
    }

    public void setDataSetConfigurations(Collection<DataSetConfiguration> dataSetConfigurations) {
        if (dataSetConfigurations == null) {
            this.dataSetConfigurations = null;
            return;
        }
        this.dataSetConfigurations = new ArrayList<DataSetConfiguration>(dataSetConfigurations);
    }

    public TemplateVersion withDataSetConfigurations(DataSetConfiguration ... dataSetConfigurations) {
        if (this.dataSetConfigurations == null) {
            this.setDataSetConfigurations(new ArrayList<DataSetConfiguration>(dataSetConfigurations.length));
        }
        for (DataSetConfiguration ele : dataSetConfigurations) {
            this.dataSetConfigurations.add(ele);
        }
        return this;
    }

    public TemplateVersion withDataSetConfigurations(Collection<DataSetConfiguration> dataSetConfigurations) {
        this.setDataSetConfigurations(dataSetConfigurations);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public TemplateVersion withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setSourceEntityArn(String sourceEntityArn) {
        this.sourceEntityArn = sourceEntityArn;
    }

    public String getSourceEntityArn() {
        return this.sourceEntityArn;
    }

    public TemplateVersion withSourceEntityArn(String sourceEntityArn) {
        this.setSourceEntityArn(sourceEntityArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCreatedTime() != null) {
            sb.append("CreatedTime: ").append(this.getCreatedTime()).append(",");
        }
        if (this.getErrors() != null) {
            sb.append("Errors: ").append(this.getErrors()).append(",");
        }
        if (this.getVersionNumber() != null) {
            sb.append("VersionNumber: ").append(this.getVersionNumber()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getDataSetConfigurations() != null) {
            sb.append("DataSetConfigurations: ").append(this.getDataSetConfigurations()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getSourceEntityArn() != null) {
            sb.append("SourceEntityArn: ").append(this.getSourceEntityArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateVersion)) {
            return false;
        }
        TemplateVersion other = (TemplateVersion)obj;
        if (other.getCreatedTime() == null ^ this.getCreatedTime() == null) {
            return false;
        }
        if (other.getCreatedTime() != null && !other.getCreatedTime().equals(this.getCreatedTime())) {
            return false;
        }
        if (other.getErrors() == null ^ this.getErrors() == null) {
            return false;
        }
        if (other.getErrors() != null && !other.getErrors().equals(this.getErrors())) {
            return false;
        }
        if (other.getVersionNumber() == null ^ this.getVersionNumber() == null) {
            return false;
        }
        if (other.getVersionNumber() != null && !other.getVersionNumber().equals(this.getVersionNumber())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getDataSetConfigurations() == null ^ this.getDataSetConfigurations() == null) {
            return false;
        }
        if (other.getDataSetConfigurations() != null && !other.getDataSetConfigurations().equals(this.getDataSetConfigurations())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getSourceEntityArn() == null ^ this.getSourceEntityArn() == null) {
            return false;
        }
        return other.getSourceEntityArn() == null || other.getSourceEntityArn().equals(this.getSourceEntityArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCreatedTime() == null ? 0 : this.getCreatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getErrors() == null ? 0 : this.getErrors().hashCode());
        hashCode = 31 * hashCode + (this.getVersionNumber() == null ? 0 : this.getVersionNumber().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getDataSetConfigurations() == null ? 0 : this.getDataSetConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getSourceEntityArn() == null ? 0 : this.getSourceEntityArn().hashCode());
        return hashCode;
    }

    public TemplateVersion clone() {
        try {
            return (TemplateVersion)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TemplateVersionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

