/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.transform.DataColorPaletteMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DataColorPalette
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> colors;
    private List<String> minMaxGradient;
    private String emptyFillColor;

    public List<String> getColors() {
        return this.colors;
    }

    public void setColors(Collection<String> colors) {
        if (colors == null) {
            this.colors = null;
            return;
        }
        this.colors = new ArrayList<String>(colors);
    }

    public DataColorPalette withColors(String ... colors) {
        if (this.colors == null) {
            this.setColors(new ArrayList<String>(colors.length));
        }
        for (String ele : colors) {
            this.colors.add(ele);
        }
        return this;
    }

    public DataColorPalette withColors(Collection<String> colors) {
        this.setColors(colors);
        return this;
    }

    public List<String> getMinMaxGradient() {
        return this.minMaxGradient;
    }

    public void setMinMaxGradient(Collection<String> minMaxGradient) {
        if (minMaxGradient == null) {
            this.minMaxGradient = null;
            return;
        }
        this.minMaxGradient = new ArrayList<String>(minMaxGradient);
    }

    public DataColorPalette withMinMaxGradient(String ... minMaxGradient) {
        if (this.minMaxGradient == null) {
            this.setMinMaxGradient(new ArrayList<String>(minMaxGradient.length));
        }
        for (String ele : minMaxGradient) {
            this.minMaxGradient.add(ele);
        }
        return this;
    }

    public DataColorPalette withMinMaxGradient(Collection<String> minMaxGradient) {
        this.setMinMaxGradient(minMaxGradient);
        return this;
    }

    public void setEmptyFillColor(String emptyFillColor) {
        this.emptyFillColor = emptyFillColor;
    }

    public String getEmptyFillColor() {
        return this.emptyFillColor;
    }

    public DataColorPalette withEmptyFillColor(String emptyFillColor) {
        this.setEmptyFillColor(emptyFillColor);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getColors() != null) {
            sb.append("Colors: ").append(this.getColors()).append(",");
        }
        if (this.getMinMaxGradient() != null) {
            sb.append("MinMaxGradient: ").append(this.getMinMaxGradient()).append(",");
        }
        if (this.getEmptyFillColor() != null) {
            sb.append("EmptyFillColor: ").append(this.getEmptyFillColor());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataColorPalette)) {
            return false;
        }
        DataColorPalette other = (DataColorPalette)obj;
        if (other.getColors() == null ^ this.getColors() == null) {
            return false;
        }
        if (other.getColors() != null && !other.getColors().equals(this.getColors())) {
            return false;
        }
        if (other.getMinMaxGradient() == null ^ this.getMinMaxGradient() == null) {
            return false;
        }
        if (other.getMinMaxGradient() != null && !other.getMinMaxGradient().equals(this.getMinMaxGradient())) {
            return false;
        }
        if (other.getEmptyFillColor() == null ^ this.getEmptyFillColor() == null) {
            return false;
        }
        return other.getEmptyFillColor() == null || other.getEmptyFillColor().equals(this.getEmptyFillColor());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getColors() == null ? 0 : this.getColors().hashCode());
        hashCode = 31 * hashCode + (this.getMinMaxGradient() == null ? 0 : this.getMinMaxGradient().hashCode());
        hashCode = 31 * hashCode + (this.getEmptyFillColor() == null ? 0 : this.getEmptyFillColor().hashCode());
        return hashCode;
    }

    public DataColorPalette clone() {
        try {
            return (DataColorPalette)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DataColorPaletteMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

