/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qbusiness.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.qbusiness.model.IndexCapacityConfiguration;
import com.amazonaws.services.qbusiness.model.IndexType;
import com.amazonaws.services.qbusiness.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateIndexRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String applicationId;
    private String displayName;
    private String type;
    private String description;
    private List<Tag> tags;
    private IndexCapacityConfiguration capacityConfiguration;
    private String clientToken;

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public CreateIndexRequest withApplicationId(String applicationId) {
        this.setApplicationId(applicationId);
        return this;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public CreateIndexRequest withDisplayName(String displayName) {
        this.setDisplayName(displayName);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public CreateIndexRequest withType(String type) {
        this.setType(type);
        return this;
    }

    public CreateIndexRequest withType(IndexType type) {
        this.type = type.toString();
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateIndexRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateIndexRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateIndexRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setCapacityConfiguration(IndexCapacityConfiguration capacityConfiguration) {
        this.capacityConfiguration = capacityConfiguration;
    }

    public IndexCapacityConfiguration getCapacityConfiguration() {
        return this.capacityConfiguration;
    }

    public CreateIndexRequest withCapacityConfiguration(IndexCapacityConfiguration capacityConfiguration) {
        this.setCapacityConfiguration(capacityConfiguration);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateIndexRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationId() != null) {
            sb.append("ApplicationId: ").append(this.getApplicationId()).append(",");
        }
        if (this.getDisplayName() != null) {
            sb.append("DisplayName: ").append(this.getDisplayName()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getCapacityConfiguration() != null) {
            sb.append("CapacityConfiguration: ").append(this.getCapacityConfiguration()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIndexRequest)) {
            return false;
        }
        CreateIndexRequest other = (CreateIndexRequest)obj;
        if (other.getApplicationId() == null ^ this.getApplicationId() == null) {
            return false;
        }
        if (other.getApplicationId() != null && !other.getApplicationId().equals(this.getApplicationId())) {
            return false;
        }
        if (other.getDisplayName() == null ^ this.getDisplayName() == null) {
            return false;
        }
        if (other.getDisplayName() != null && !other.getDisplayName().equals(this.getDisplayName())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getCapacityConfiguration() == null ^ this.getCapacityConfiguration() == null) {
            return false;
        }
        if (other.getCapacityConfiguration() != null && !other.getCapacityConfiguration().equals(this.getCapacityConfiguration())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        return other.getClientToken() == null || other.getClientToken().equals(this.getClientToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationId() == null ? 0 : this.getApplicationId().hashCode());
        hashCode = 31 * hashCode + (this.getDisplayName() == null ? 0 : this.getDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getCapacityConfiguration() == null ? 0 : this.getCapacityConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        return hashCode;
    }

    public CreateIndexRequest clone() {
        return (CreateIndexRequest)super.clone();
    }
}

