/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qbusiness.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.qbusiness.model.AccessConfiguration;
import com.amazonaws.services.qbusiness.model.ContentType;
import com.amazonaws.services.qbusiness.model.DocumentAttribute;
import com.amazonaws.services.qbusiness.model.DocumentContent;
import com.amazonaws.services.qbusiness.model.DocumentEnrichmentConfiguration;
import com.amazonaws.services.qbusiness.model.transform.DocumentMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Document
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private List<DocumentAttribute> attributes;
    private DocumentContent content;
    private String contentType;
    private String title;
    private AccessConfiguration accessConfiguration;
    private DocumentEnrichmentConfiguration documentEnrichmentConfiguration;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Document withId(String id) {
        this.setId(id);
        return this;
    }

    public List<DocumentAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Collection<DocumentAttribute> attributes) {
        if (attributes == null) {
            this.attributes = null;
            return;
        }
        this.attributes = new ArrayList<DocumentAttribute>(attributes);
    }

    public Document withAttributes(DocumentAttribute ... attributes) {
        if (this.attributes == null) {
            this.setAttributes(new ArrayList<DocumentAttribute>(attributes.length));
        }
        for (DocumentAttribute ele : attributes) {
            this.attributes.add(ele);
        }
        return this;
    }

    public Document withAttributes(Collection<DocumentAttribute> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public void setContent(DocumentContent content) {
        this.content = content;
    }

    public DocumentContent getContent() {
        return this.content;
    }

    public Document withContent(DocumentContent content) {
        this.setContent(content);
        return this;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Document withContentType(String contentType) {
        this.setContentType(contentType);
        return this;
    }

    public Document withContentType(ContentType contentType) {
        this.contentType = contentType.toString();
        return this;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public Document withTitle(String title) {
        this.setTitle(title);
        return this;
    }

    public void setAccessConfiguration(AccessConfiguration accessConfiguration) {
        this.accessConfiguration = accessConfiguration;
    }

    public AccessConfiguration getAccessConfiguration() {
        return this.accessConfiguration;
    }

    public Document withAccessConfiguration(AccessConfiguration accessConfiguration) {
        this.setAccessConfiguration(accessConfiguration);
        return this;
    }

    public void setDocumentEnrichmentConfiguration(DocumentEnrichmentConfiguration documentEnrichmentConfiguration) {
        this.documentEnrichmentConfiguration = documentEnrichmentConfiguration;
    }

    public DocumentEnrichmentConfiguration getDocumentEnrichmentConfiguration() {
        return this.documentEnrichmentConfiguration;
    }

    public Document withDocumentEnrichmentConfiguration(DocumentEnrichmentConfiguration documentEnrichmentConfiguration) {
        this.setDocumentEnrichmentConfiguration(documentEnrichmentConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes()).append(",");
        }
        if (this.getContent() != null) {
            sb.append("Content: ").append(this.getContent()).append(",");
        }
        if (this.getContentType() != null) {
            sb.append("ContentType: ").append(this.getContentType()).append(",");
        }
        if (this.getTitle() != null) {
            sb.append("Title: ").append(this.getTitle()).append(",");
        }
        if (this.getAccessConfiguration() != null) {
            sb.append("AccessConfiguration: ").append(this.getAccessConfiguration()).append(",");
        }
        if (this.getDocumentEnrichmentConfiguration() != null) {
            sb.append("DocumentEnrichmentConfiguration: ").append(this.getDocumentEnrichmentConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Document)) {
            return false;
        }
        Document other = (Document)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getContent() == null ^ this.getContent() == null) {
            return false;
        }
        if (other.getContent() != null && !other.getContent().equals(this.getContent())) {
            return false;
        }
        if (other.getContentType() == null ^ this.getContentType() == null) {
            return false;
        }
        if (other.getContentType() != null && !other.getContentType().equals(this.getContentType())) {
            return false;
        }
        if (other.getTitle() == null ^ this.getTitle() == null) {
            return false;
        }
        if (other.getTitle() != null && !other.getTitle().equals(this.getTitle())) {
            return false;
        }
        if (other.getAccessConfiguration() == null ^ this.getAccessConfiguration() == null) {
            return false;
        }
        if (other.getAccessConfiguration() != null && !other.getAccessConfiguration().equals(this.getAccessConfiguration())) {
            return false;
        }
        if (other.getDocumentEnrichmentConfiguration() == null ^ this.getDocumentEnrichmentConfiguration() == null) {
            return false;
        }
        return other.getDocumentEnrichmentConfiguration() == null || other.getDocumentEnrichmentConfiguration().equals(this.getDocumentEnrichmentConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getContent() == null ? 0 : this.getContent().hashCode());
        hashCode = 31 * hashCode + (this.getContentType() == null ? 0 : this.getContentType().hashCode());
        hashCode = 31 * hashCode + (this.getTitle() == null ? 0 : this.getTitle().hashCode());
        hashCode = 31 * hashCode + (this.getAccessConfiguration() == null ? 0 : this.getAccessConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentEnrichmentConfiguration() == null ? 0 : this.getDocumentEnrichmentConfiguration().hashCode());
        return hashCode;
    }

    public Document clone() {
        try {
            return (Document)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DocumentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

