/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qbusiness.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.qbusiness.model.DataSource;
import java.util.Date;

@SdkInternalApi
public class DataSourceMarshaller {
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> DATASOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dataSourceId").build();
    private static final MarshallingInfo<String> DISPLAYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("displayName").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final MarshallingInfo<Date> UPDATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("updatedAt").timestampFormat("unixTimestamp").build();
    private static final DataSourceMarshaller instance = new DataSourceMarshaller();

    public static DataSourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataSource dataSource, ProtocolMarshaller protocolMarshaller) {
        if (dataSource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dataSource.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)dataSource.getDataSourceId(), DATASOURCEID_BINDING);
            protocolMarshaller.marshall((Object)dataSource.getDisplayName(), DISPLAYNAME_BINDING);
            protocolMarshaller.marshall((Object)dataSource.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)dataSource.getType(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)dataSource.getUpdatedAt(), UPDATEDAT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

