/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qbusiness.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.qbusiness.model.Retriever;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListRetrieversResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<Retriever> retrievers;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListRetrieversResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<Retriever> getRetrievers() {
        return this.retrievers;
    }

    public void setRetrievers(Collection<Retriever> retrievers) {
        if (retrievers == null) {
            this.retrievers = null;
            return;
        }
        this.retrievers = new ArrayList<Retriever>(retrievers);
    }

    public ListRetrieversResult withRetrievers(Retriever ... retrievers) {
        if (this.retrievers == null) {
            this.setRetrievers(new ArrayList<Retriever>(retrievers.length));
        }
        for (Retriever ele : retrievers) {
            this.retrievers.add(ele);
        }
        return this;
    }

    public ListRetrieversResult withRetrievers(Collection<Retriever> retrievers) {
        this.setRetrievers(retrievers);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getRetrievers() != null) {
            sb.append("Retrievers: ").append(this.getRetrievers());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRetrieversResult)) {
            return false;
        }
        ListRetrieversResult other = (ListRetrieversResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getRetrievers() == null ^ this.getRetrievers() == null) {
            return false;
        }
        return other.getRetrievers() == null || other.getRetrievers().equals(this.getRetrievers());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getRetrievers() == null ? 0 : this.getRetrievers().hashCode());
        return hashCode;
    }

    public ListRetrieversResult clone() {
        try {
            return (ListRetrieversResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

