/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.qbusiness.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Rules for retrieving content from data sources connected to a Amazon Q application for a specific topic control
 * configuration.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ContentRetrievalRule" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ContentRetrievalRule implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Specifies data sources in a Amazon Q application to use for content generation.
     * </p>
     */
    private java.util.List<EligibleDataSource> eligibleDataSources;

    /**
     * <p>
     * Specifies data sources in a Amazon Q application to use for content generation.
     * </p>
     * 
     * @return Specifies data sources in a Amazon Q application to use for content generation.
     */

    public java.util.List<EligibleDataSource> getEligibleDataSources() {
        return eligibleDataSources;
    }

    /**
     * <p>
     * Specifies data sources in a Amazon Q application to use for content generation.
     * </p>
     * 
     * @param eligibleDataSources
     *        Specifies data sources in a Amazon Q application to use for content generation.
     */

    public void setEligibleDataSources(java.util.Collection<EligibleDataSource> eligibleDataSources) {
        if (eligibleDataSources == null) {
            this.eligibleDataSources = null;
            return;
        }

        this.eligibleDataSources = new java.util.ArrayList<EligibleDataSource>(eligibleDataSources);
    }

    /**
     * <p>
     * Specifies data sources in a Amazon Q application to use for content generation.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setEligibleDataSources(java.util.Collection)} or {@link #withEligibleDataSources(java.util.Collection)}
     * if you want to override the existing values.
     * </p>
     * 
     * @param eligibleDataSources
     *        Specifies data sources in a Amazon Q application to use for content generation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ContentRetrievalRule withEligibleDataSources(EligibleDataSource... eligibleDataSources) {
        if (this.eligibleDataSources == null) {
            setEligibleDataSources(new java.util.ArrayList<EligibleDataSource>(eligibleDataSources.length));
        }
        for (EligibleDataSource ele : eligibleDataSources) {
            this.eligibleDataSources.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Specifies data sources in a Amazon Q application to use for content generation.
     * </p>
     * 
     * @param eligibleDataSources
     *        Specifies data sources in a Amazon Q application to use for content generation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ContentRetrievalRule withEligibleDataSources(java.util.Collection<EligibleDataSource> eligibleDataSources) {
        setEligibleDataSources(eligibleDataSources);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getEligibleDataSources() != null)
            sb.append("EligibleDataSources: ").append(getEligibleDataSources());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ContentRetrievalRule == false)
            return false;
        ContentRetrievalRule other = (ContentRetrievalRule) obj;
        if (other.getEligibleDataSources() == null ^ this.getEligibleDataSources() == null)
            return false;
        if (other.getEligibleDataSources() != null && other.getEligibleDataSources().equals(this.getEligibleDataSources()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getEligibleDataSources() == null) ? 0 : getEligibleDataSources().hashCode());
        return hashCode;
    }

    @Override
    public ContentRetrievalRule clone() {
        try {
            return (ContentRetrievalRule) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.qbusiness.model.transform.ContentRetrievalRuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
