/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qbusiness.model.transform;

import com.amazonaws.services.qbusiness.model.S3;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class S3JsonUnmarshaller
implements Unmarshaller<S3, JsonUnmarshallerContext> {
    private static S3JsonUnmarshaller instance;

    public S3 unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3 s3 = new S3();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("bucket", targetDepth)) {
                    context.nextToken();
                    s3.setBucket((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("key", targetDepth)) {
                    context.nextToken();
                    s3.setKey((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return s3;
    }

    public static S3JsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3JsonUnmarshaller();
        }
        return instance;
    }
}

