/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qbusiness.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.qbusiness.model.Rule;
import com.amazonaws.services.qbusiness.model.transform.TopicConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TopicConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String description;
    private List<String> exampleChatMessages;
    private String name;
    private List<Rule> rules;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public TopicConfiguration withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<String> getExampleChatMessages() {
        return this.exampleChatMessages;
    }

    public void setExampleChatMessages(Collection<String> exampleChatMessages) {
        if (exampleChatMessages == null) {
            this.exampleChatMessages = null;
            return;
        }
        this.exampleChatMessages = new ArrayList<String>(exampleChatMessages);
    }

    public TopicConfiguration withExampleChatMessages(String ... exampleChatMessages) {
        if (this.exampleChatMessages == null) {
            this.setExampleChatMessages(new ArrayList<String>(exampleChatMessages.length));
        }
        for (String ele : exampleChatMessages) {
            this.exampleChatMessages.add(ele);
        }
        return this;
    }

    public TopicConfiguration withExampleChatMessages(Collection<String> exampleChatMessages) {
        this.setExampleChatMessages(exampleChatMessages);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public TopicConfiguration withName(String name) {
        this.setName(name);
        return this;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public void setRules(Collection<Rule> rules) {
        if (rules == null) {
            this.rules = null;
            return;
        }
        this.rules = new ArrayList<Rule>(rules);
    }

    public TopicConfiguration withRules(Rule ... rules) {
        if (this.rules == null) {
            this.setRules(new ArrayList<Rule>(rules.length));
        }
        for (Rule ele : rules) {
            this.rules.add(ele);
        }
        return this;
    }

    public TopicConfiguration withRules(Collection<Rule> rules) {
        this.setRules(rules);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getExampleChatMessages() != null) {
            sb.append("ExampleChatMessages: ").append(this.getExampleChatMessages()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getRules() != null) {
            sb.append("Rules: ").append(this.getRules());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicConfiguration)) {
            return false;
        }
        TopicConfiguration other = (TopicConfiguration)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getExampleChatMessages() == null ^ this.getExampleChatMessages() == null) {
            return false;
        }
        if (other.getExampleChatMessages() != null && !other.getExampleChatMessages().equals(this.getExampleChatMessages())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getRules() == null ^ this.getRules() == null) {
            return false;
        }
        return other.getRules() == null || other.getRules().equals(this.getRules());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getExampleChatMessages() == null ? 0 : this.getExampleChatMessages().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getRules() == null ? 0 : this.getRules().hashCode());
        return hashCode;
    }

    public TopicConfiguration clone() {
        try {
            return (TopicConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TopicConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

