/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qapps.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.qapps.model.CardType;
import com.amazonaws.services.qapps.model.transform.TextInputCardMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TextInputCard
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private String title;
    private List<String> dependencies;
    private String type;
    private String placeholder;
    private String defaultValue;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public TextInputCard withId(String id) {
        this.setId(id);
        return this;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public TextInputCard withTitle(String title) {
        this.setTitle(title);
        return this;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(Collection<String> dependencies) {
        if (dependencies == null) {
            this.dependencies = null;
            return;
        }
        this.dependencies = new ArrayList<String>(dependencies);
    }

    public TextInputCard withDependencies(String ... dependencies) {
        if (this.dependencies == null) {
            this.setDependencies(new ArrayList<String>(dependencies.length));
        }
        for (String ele : dependencies) {
            this.dependencies.add(ele);
        }
        return this;
    }

    public TextInputCard withDependencies(Collection<String> dependencies) {
        this.setDependencies(dependencies);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public TextInputCard withType(String type) {
        this.setType(type);
        return this;
    }

    public TextInputCard withType(CardType type) {
        this.type = type.toString();
        return this;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public TextInputCard withPlaceholder(String placeholder) {
        this.setPlaceholder(placeholder);
        return this;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public TextInputCard withDefaultValue(String defaultValue) {
        this.setDefaultValue(defaultValue);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getTitle() != null) {
            sb.append("Title: ").append(this.getTitle()).append(",");
        }
        if (this.getDependencies() != null) {
            sb.append("Dependencies: ").append(this.getDependencies()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getPlaceholder() != null) {
            sb.append("Placeholder: ").append(this.getPlaceholder()).append(",");
        }
        if (this.getDefaultValue() != null) {
            sb.append("DefaultValue: ").append(this.getDefaultValue());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextInputCard)) {
            return false;
        }
        TextInputCard other = (TextInputCard)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getTitle() == null ^ this.getTitle() == null) {
            return false;
        }
        if (other.getTitle() != null && !other.getTitle().equals(this.getTitle())) {
            return false;
        }
        if (other.getDependencies() == null ^ this.getDependencies() == null) {
            return false;
        }
        if (other.getDependencies() != null && !other.getDependencies().equals(this.getDependencies())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getPlaceholder() == null ^ this.getPlaceholder() == null) {
            return false;
        }
        if (other.getPlaceholder() != null && !other.getPlaceholder().equals(this.getPlaceholder())) {
            return false;
        }
        if (other.getDefaultValue() == null ^ this.getDefaultValue() == null) {
            return false;
        }
        return other.getDefaultValue() == null || other.getDefaultValue().equals(this.getDefaultValue());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getTitle() == null ? 0 : this.getTitle().hashCode());
        hashCode = 31 * hashCode + (this.getDependencies() == null ? 0 : this.getDependencies().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getPlaceholder() == null ? 0 : this.getPlaceholder().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultValue() == null ? 0 : this.getDefaultValue().hashCode());
        return hashCode;
    }

    public TextInputCard clone() {
        try {
            return (TextInputCard)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TextInputCardMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

