/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.proton.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.proton.model.ResourceSyncEvent;
import com.amazonaws.services.proton.model.ResourceSyncStatus;
import com.amazonaws.services.proton.model.Revision;
import com.amazonaws.services.proton.model.transform.ResourceSyncAttemptMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ResourceSyncAttempt
implements Serializable,
Cloneable,
StructuredPojo {
    private List<ResourceSyncEvent> events;
    private Revision initialRevision;
    private Date startedAt;
    private String status;
    private String target;
    private Revision targetRevision;

    public List<ResourceSyncEvent> getEvents() {
        return this.events;
    }

    public void setEvents(Collection<ResourceSyncEvent> events) {
        if (events == null) {
            this.events = null;
            return;
        }
        this.events = new ArrayList<ResourceSyncEvent>(events);
    }

    public ResourceSyncAttempt withEvents(ResourceSyncEvent ... events) {
        if (this.events == null) {
            this.setEvents(new ArrayList<ResourceSyncEvent>(events.length));
        }
        for (ResourceSyncEvent ele : events) {
            this.events.add(ele);
        }
        return this;
    }

    public ResourceSyncAttempt withEvents(Collection<ResourceSyncEvent> events) {
        this.setEvents(events);
        return this;
    }

    public void setInitialRevision(Revision initialRevision) {
        this.initialRevision = initialRevision;
    }

    public Revision getInitialRevision() {
        return this.initialRevision;
    }

    public ResourceSyncAttempt withInitialRevision(Revision initialRevision) {
        this.setInitialRevision(initialRevision);
        return this;
    }

    public void setStartedAt(Date startedAt) {
        this.startedAt = startedAt;
    }

    public Date getStartedAt() {
        return this.startedAt;
    }

    public ResourceSyncAttempt withStartedAt(Date startedAt) {
        this.setStartedAt(startedAt);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public ResourceSyncAttempt withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public ResourceSyncAttempt withStatus(ResourceSyncStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getTarget() {
        return this.target;
    }

    public ResourceSyncAttempt withTarget(String target) {
        this.setTarget(target);
        return this;
    }

    public void setTargetRevision(Revision targetRevision) {
        this.targetRevision = targetRevision;
    }

    public Revision getTargetRevision() {
        return this.targetRevision;
    }

    public ResourceSyncAttempt withTargetRevision(Revision targetRevision) {
        this.setTargetRevision(targetRevision);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEvents() != null) {
            sb.append("Events: ").append(this.getEvents()).append(",");
        }
        if (this.getInitialRevision() != null) {
            sb.append("InitialRevision: ").append(this.getInitialRevision()).append(",");
        }
        if (this.getStartedAt() != null) {
            sb.append("StartedAt: ").append(this.getStartedAt()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getTarget() != null) {
            sb.append("Target: ").append(this.getTarget()).append(",");
        }
        if (this.getTargetRevision() != null) {
            sb.append("TargetRevision: ").append(this.getTargetRevision());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceSyncAttempt)) {
            return false;
        }
        ResourceSyncAttempt other = (ResourceSyncAttempt)obj;
        if (other.getEvents() == null ^ this.getEvents() == null) {
            return false;
        }
        if (other.getEvents() != null && !other.getEvents().equals(this.getEvents())) {
            return false;
        }
        if (other.getInitialRevision() == null ^ this.getInitialRevision() == null) {
            return false;
        }
        if (other.getInitialRevision() != null && !other.getInitialRevision().equals(this.getInitialRevision())) {
            return false;
        }
        if (other.getStartedAt() == null ^ this.getStartedAt() == null) {
            return false;
        }
        if (other.getStartedAt() != null && !other.getStartedAt().equals(this.getStartedAt())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getTarget() == null ^ this.getTarget() == null) {
            return false;
        }
        if (other.getTarget() != null && !other.getTarget().equals(this.getTarget())) {
            return false;
        }
        if (other.getTargetRevision() == null ^ this.getTargetRevision() == null) {
            return false;
        }
        return other.getTargetRevision() == null || other.getTargetRevision().equals(this.getTargetRevision());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEvents() == null ? 0 : this.getEvents().hashCode());
        hashCode = 31 * hashCode + (this.getInitialRevision() == null ? 0 : this.getInitialRevision().hashCode());
        hashCode = 31 * hashCode + (this.getStartedAt() == null ? 0 : this.getStartedAt().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getTarget() == null ? 0 : this.getTarget().hashCode());
        hashCode = 31 * hashCode + (this.getTargetRevision() == null ? 0 : this.getTargetRevision().hashCode());
        return hashCode;
    }

    public ResourceSyncAttempt clone() {
        try {
            return (ResourceSyncAttempt)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceSyncAttemptMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

