/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.proton.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.proton.model.Output;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListComponentOutputsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<Output> outputs;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListComponentOutputsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<Output> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(Collection<Output> outputs) {
        if (outputs == null) {
            this.outputs = null;
            return;
        }
        this.outputs = new ArrayList<Output>(outputs);
    }

    public ListComponentOutputsResult withOutputs(Output ... outputs) {
        if (this.outputs == null) {
            this.setOutputs(new ArrayList<Output>(outputs.length));
        }
        for (Output ele : outputs) {
            this.outputs.add(ele);
        }
        return this;
    }

    public ListComponentOutputsResult withOutputs(Collection<Output> outputs) {
        this.setOutputs(outputs);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getOutputs() != null) {
            sb.append("Outputs: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComponentOutputsResult)) {
            return false;
        }
        ListComponentOutputsResult other = (ListComponentOutputsResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getOutputs() == null ^ this.getOutputs() == null) {
            return false;
        }
        return other.getOutputs() == null || other.getOutputs().equals(this.getOutputs());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getOutputs() == null ? 0 : this.getOutputs().hashCode());
        return hashCode;
    }

    public ListComponentOutputsResult clone() {
        try {
            return (ListComponentOutputsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

