/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.prometheus.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.prometheus.model.ScraperSummary;
import java.util.Date;
import java.util.Map;

@SdkInternalApi
public class ScraperSummaryMarshaller {
    private static final MarshallingInfo<String> ALIAS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("alias").build();
    private static final MarshallingInfo<String> SCRAPERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scraperId").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").build();
    private static final MarshallingInfo<StructuredPojo> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTMODIFIEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastModifiedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final MarshallingInfo<String> STATUSREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusReason").build();
    private static final MarshallingInfo<StructuredPojo> SOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("source").build();
    private static final MarshallingInfo<StructuredPojo> DESTINATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destination").build();
    private static final ScraperSummaryMarshaller instance = new ScraperSummaryMarshaller();

    public static ScraperSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(ScraperSummary scraperSummary, ProtocolMarshaller protocolMarshaller) {
        if (scraperSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)scraperSummary.getAlias(), ALIAS_BINDING);
            protocolMarshaller.marshall((Object)scraperSummary.getScraperId(), SCRAPERID_BINDING);
            protocolMarshaller.marshall((Object)scraperSummary.getArn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)scraperSummary.getRoleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)scraperSummary.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)scraperSummary.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)scraperSummary.getLastModifiedAt(), LASTMODIFIEDAT_BINDING);
            protocolMarshaller.marshall(scraperSummary.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)scraperSummary.getStatusReason(), STATUSREASON_BINDING);
            protocolMarshaller.marshall((Object)scraperSummary.getSource(), SOURCE_BINDING);
            protocolMarshaller.marshall((Object)scraperSummary.getDestination(), DESTINATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

