/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.polly;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.polly.AmazonPolly;
import com.amazonaws.services.polly.model.AmazonPollyException;
import com.amazonaws.services.polly.model.DeleteLexiconRequest;
import com.amazonaws.services.polly.model.DeleteLexiconResult;
import com.amazonaws.services.polly.model.DescribeVoicesRequest;
import com.amazonaws.services.polly.model.DescribeVoicesResult;
import com.amazonaws.services.polly.model.GetLexiconRequest;
import com.amazonaws.services.polly.model.GetLexiconResult;
import com.amazonaws.services.polly.model.InvalidLexiconException;
import com.amazonaws.services.polly.model.InvalidNextTokenException;
import com.amazonaws.services.polly.model.InvalidSampleRateException;
import com.amazonaws.services.polly.model.InvalidSsmlException;
import com.amazonaws.services.polly.model.LexiconNotFoundException;
import com.amazonaws.services.polly.model.LexiconSizeExceededException;
import com.amazonaws.services.polly.model.ListLexiconsRequest;
import com.amazonaws.services.polly.model.ListLexiconsResult;
import com.amazonaws.services.polly.model.MaxLexemeLengthExceededException;
import com.amazonaws.services.polly.model.MaxLexiconsNumberExceededException;
import com.amazonaws.services.polly.model.PutLexiconRequest;
import com.amazonaws.services.polly.model.PutLexiconResult;
import com.amazonaws.services.polly.model.ServiceFailureException;
import com.amazonaws.services.polly.model.SynthesizeSpeechRequest;
import com.amazonaws.services.polly.model.SynthesizeSpeechResult;
import com.amazonaws.services.polly.model.TextLengthExceededException;
import com.amazonaws.services.polly.model.UnsupportedPlsAlphabetException;
import com.amazonaws.services.polly.model.UnsupportedPlsLanguageException;
import com.amazonaws.services.polly.model.transform.DeleteLexiconRequestMarshaller;
import com.amazonaws.services.polly.model.transform.DeleteLexiconResultJsonUnmarshaller;
import com.amazonaws.services.polly.model.transform.DescribeVoicesRequestMarshaller;
import com.amazonaws.services.polly.model.transform.DescribeVoicesResultJsonUnmarshaller;
import com.amazonaws.services.polly.model.transform.GetLexiconRequestMarshaller;
import com.amazonaws.services.polly.model.transform.GetLexiconResultJsonUnmarshaller;
import com.amazonaws.services.polly.model.transform.ListLexiconsRequestMarshaller;
import com.amazonaws.services.polly.model.transform.ListLexiconsResultJsonUnmarshaller;
import com.amazonaws.services.polly.model.transform.PutLexiconRequestMarshaller;
import com.amazonaws.services.polly.model.transform.PutLexiconResultJsonUnmarshaller;
import com.amazonaws.services.polly.model.transform.SynthesizeSpeechRequestMarshaller;
import com.amazonaws.services.polly.model.transform.SynthesizeSpeechResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.ValidationUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonPollyClient
extends AmazonWebServiceClient
implements AmazonPolly {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonPolly.class);
    private static final String DEFAULT_SIGNING_NAME = "polly";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidSampleRateException").withModeledClass(InvalidSampleRateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MaxLexiconsNumberExceededException").withModeledClass(MaxLexiconsNumberExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MaxLexemeLengthExceededException").withModeledClass(MaxLexemeLengthExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedPlsLanguageException").withModeledClass(UnsupportedPlsLanguageException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedPlsAlphabetException").withModeledClass(UnsupportedPlsAlphabetException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TextLengthExceededException").withModeledClass(TextLengthExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LexiconNotFoundException").withModeledClass(LexiconNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LexiconSizeExceededException").withModeledClass(LexiconSizeExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidLexiconException").withModeledClass(InvalidLexiconException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidSsmlException").withModeledClass(InvalidSsmlException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidNextTokenException").withModeledClass(InvalidNextTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceFailureException").withModeledClass(ServiceFailureException.class)).withBaseServiceExceptionClass(AmazonPollyException.class));

    public AmazonPollyClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    public AmazonPollyClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    public AmazonPollyClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    public AmazonPollyClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonPollyClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    public AmazonPollyClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonPollyClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    AmazonPollyClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("polly.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/polly/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/polly/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLexiconResult deleteLexicon(DeleteLexiconRequest deleteLexiconRequest) {
        ValidationUtils.assertStringNotEmpty((String)StringUtils.fromString((String)deleteLexiconRequest.getName()), (String)"Name");
        ExecutionContext executionContext = this.createExecutionContext(deleteLexiconRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteLexiconRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteLexiconRequestMarshaller(this.protocolFactory).marshall((DeleteLexiconRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteLexiconRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteLexiconResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteLexiconResult deleteLexiconResult = (DeleteLexiconResult)response.getAwsResponse();
            return deleteLexiconResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeVoicesResult describeVoices(DescribeVoicesRequest describeVoicesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeVoicesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeVoicesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeVoicesRequestMarshaller(this.protocolFactory).marshall((DescribeVoicesRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeVoicesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeVoicesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeVoicesResult describeVoicesResult = (DescribeVoicesResult)response.getAwsResponse();
            return describeVoicesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLexiconResult getLexicon(GetLexiconRequest getLexiconRequest) {
        ValidationUtils.assertStringNotEmpty((String)StringUtils.fromString((String)getLexiconRequest.getName()), (String)"Name");
        ExecutionContext executionContext = this.createExecutionContext(getLexiconRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetLexiconRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetLexiconRequestMarshaller(this.protocolFactory).marshall((GetLexiconRequest)super.beforeMarshalling((AmazonWebServiceRequest)getLexiconRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetLexiconResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetLexiconResult getLexiconResult = (GetLexiconResult)response.getAwsResponse();
            return getLexiconResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListLexiconsResult listLexicons(ListLexiconsRequest listLexiconsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listLexiconsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListLexiconsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListLexiconsRequestMarshaller(this.protocolFactory).marshall((ListLexiconsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listLexiconsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListLexiconsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListLexiconsResult listLexiconsResult = (ListLexiconsResult)response.getAwsResponse();
            return listLexiconsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutLexiconResult putLexicon(PutLexiconRequest putLexiconRequest) {
        ValidationUtils.assertStringNotEmpty((String)StringUtils.fromString((String)putLexiconRequest.getName()), (String)"Name");
        ExecutionContext executionContext = this.createExecutionContext(putLexiconRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutLexiconRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutLexiconRequestMarshaller(this.protocolFactory).marshall((PutLexiconRequest)super.beforeMarshalling((AmazonWebServiceRequest)putLexiconRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutLexiconResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutLexiconResult putLexiconResult = (PutLexiconResult)response.getAwsResponse();
            return putLexiconResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynthesizeSpeechResult synthesizeSpeech(SynthesizeSpeechRequest synthesizeSpeechRequest) {
        ExecutionContext executionContext = this.createExecutionContext(synthesizeSpeechRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SynthesizeSpeechRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SynthesizeSpeechRequestMarshaller(this.protocolFactory).marshall((SynthesizeSpeechRequest)super.beforeMarshalling((AmazonWebServiceRequest)synthesizeSpeechRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(false).withHasStreamingSuccessResponse(true), (Unmarshaller)new SynthesizeSpeechResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SynthesizeSpeechResult synthesizeSpeechResult = (SynthesizeSpeechResult)response.getAwsResponse();
            return synthesizeSpeechResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

