/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pipes;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.pipes.AmazonPipesAsync;
import com.amazonaws.services.pipes.AmazonPipesAsyncClientBuilder;
import com.amazonaws.services.pipes.AmazonPipesClient;
import com.amazonaws.services.pipes.model.CreatePipeRequest;
import com.amazonaws.services.pipes.model.CreatePipeResult;
import com.amazonaws.services.pipes.model.DeletePipeRequest;
import com.amazonaws.services.pipes.model.DeletePipeResult;
import com.amazonaws.services.pipes.model.DescribePipeRequest;
import com.amazonaws.services.pipes.model.DescribePipeResult;
import com.amazonaws.services.pipes.model.ListPipesRequest;
import com.amazonaws.services.pipes.model.ListPipesResult;
import com.amazonaws.services.pipes.model.ListTagsForResourceRequest;
import com.amazonaws.services.pipes.model.ListTagsForResourceResult;
import com.amazonaws.services.pipes.model.StartPipeRequest;
import com.amazonaws.services.pipes.model.StartPipeResult;
import com.amazonaws.services.pipes.model.StopPipeRequest;
import com.amazonaws.services.pipes.model.StopPipeResult;
import com.amazonaws.services.pipes.model.TagResourceRequest;
import com.amazonaws.services.pipes.model.TagResourceResult;
import com.amazonaws.services.pipes.model.UntagResourceRequest;
import com.amazonaws.services.pipes.model.UntagResourceResult;
import com.amazonaws.services.pipes.model.UpdatePipeRequest;
import com.amazonaws.services.pipes.model.UpdatePipeResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonPipesAsyncClient
extends AmazonPipesClient
implements AmazonPipesAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonPipesAsyncClientBuilder asyncBuilder() {
        return AmazonPipesAsyncClientBuilder.standard();
    }

    AmazonPipesAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonPipesAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreatePipeResult> createPipeAsync(CreatePipeRequest request) {
        return this.createPipeAsync(request, null);
    }

    @Override
    public Future<CreatePipeResult> createPipeAsync(CreatePipeRequest request, final AsyncHandler<CreatePipeRequest, CreatePipeResult> asyncHandler) {
        final CreatePipeRequest finalRequest = (CreatePipeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreatePipeResult>(){

            @Override
            public CreatePipeResult call() throws Exception {
                CreatePipeResult result = null;
                try {
                    result = AmazonPipesAsyncClient.this.executeCreatePipe(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePipeResult> deletePipeAsync(DeletePipeRequest request) {
        return this.deletePipeAsync(request, null);
    }

    @Override
    public Future<DeletePipeResult> deletePipeAsync(DeletePipeRequest request, final AsyncHandler<DeletePipeRequest, DeletePipeResult> asyncHandler) {
        final DeletePipeRequest finalRequest = (DeletePipeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeletePipeResult>(){

            @Override
            public DeletePipeResult call() throws Exception {
                DeletePipeResult result = null;
                try {
                    result = AmazonPipesAsyncClient.this.executeDeletePipe(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribePipeResult> describePipeAsync(DescribePipeRequest request) {
        return this.describePipeAsync(request, null);
    }

    @Override
    public Future<DescribePipeResult> describePipeAsync(DescribePipeRequest request, final AsyncHandler<DescribePipeRequest, DescribePipeResult> asyncHandler) {
        final DescribePipeRequest finalRequest = (DescribePipeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribePipeResult>(){

            @Override
            public DescribePipeResult call() throws Exception {
                DescribePipeResult result = null;
                try {
                    result = AmazonPipesAsyncClient.this.executeDescribePipe(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPipesResult> listPipesAsync(ListPipesRequest request) {
        return this.listPipesAsync(request, null);
    }

    @Override
    public Future<ListPipesResult> listPipesAsync(ListPipesRequest request, final AsyncHandler<ListPipesRequest, ListPipesResult> asyncHandler) {
        final ListPipesRequest finalRequest = (ListPipesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPipesResult>(){

            @Override
            public ListPipesResult call() throws Exception {
                ListPipesResult result = null;
                try {
                    result = AmazonPipesAsyncClient.this.executeListPipes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonPipesAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartPipeResult> startPipeAsync(StartPipeRequest request) {
        return this.startPipeAsync(request, null);
    }

    @Override
    public Future<StartPipeResult> startPipeAsync(StartPipeRequest request, final AsyncHandler<StartPipeRequest, StartPipeResult> asyncHandler) {
        final StartPipeRequest finalRequest = (StartPipeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartPipeResult>(){

            @Override
            public StartPipeResult call() throws Exception {
                StartPipeResult result = null;
                try {
                    result = AmazonPipesAsyncClient.this.executeStartPipe(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopPipeResult> stopPipeAsync(StopPipeRequest request) {
        return this.stopPipeAsync(request, null);
    }

    @Override
    public Future<StopPipeResult> stopPipeAsync(StopPipeRequest request, final AsyncHandler<StopPipeRequest, StopPipeResult> asyncHandler) {
        final StopPipeRequest finalRequest = (StopPipeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopPipeResult>(){

            @Override
            public StopPipeResult call() throws Exception {
                StopPipeResult result = null;
                try {
                    result = AmazonPipesAsyncClient.this.executeStopPipe(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonPipesAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonPipesAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdatePipeResult> updatePipeAsync(UpdatePipeRequest request) {
        return this.updatePipeAsync(request, null);
    }

    @Override
    public Future<UpdatePipeResult> updatePipeAsync(UpdatePipeRequest request, final AsyncHandler<UpdatePipeRequest, UpdatePipeResult> asyncHandler) {
        final UpdatePipeRequest finalRequest = (UpdatePipeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdatePipeResult>(){

            @Override
            public UpdatePipeResult call() throws Exception {
                UpdatePipeResult result = null;
                try {
                    result = AmazonPipesAsyncClient.this.executeUpdatePipe(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

