/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpointsmsvoicev2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.pinpointsmsvoicev2.model.KeywordFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeKeywordsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String originationIdentity;
    private List<String> keywords;
    private List<KeywordFilter> filters;
    private String nextToken;
    private Integer maxResults;

    public void setOriginationIdentity(String originationIdentity) {
        this.originationIdentity = originationIdentity;
    }

    public String getOriginationIdentity() {
        return this.originationIdentity;
    }

    public DescribeKeywordsRequest withOriginationIdentity(String originationIdentity) {
        this.setOriginationIdentity(originationIdentity);
        return this;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(Collection<String> keywords) {
        if (keywords == null) {
            this.keywords = null;
            return;
        }
        this.keywords = new ArrayList<String>(keywords);
    }

    public DescribeKeywordsRequest withKeywords(String ... keywords) {
        if (this.keywords == null) {
            this.setKeywords(new ArrayList<String>(keywords.length));
        }
        for (String ele : keywords) {
            this.keywords.add(ele);
        }
        return this;
    }

    public DescribeKeywordsRequest withKeywords(Collection<String> keywords) {
        this.setKeywords(keywords);
        return this;
    }

    public List<KeywordFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<KeywordFilter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new ArrayList<KeywordFilter>(filters);
    }

    public DescribeKeywordsRequest withFilters(KeywordFilter ... filters) {
        if (this.filters == null) {
            this.setFilters(new ArrayList<KeywordFilter>(filters.length));
        }
        for (KeywordFilter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public DescribeKeywordsRequest withFilters(Collection<KeywordFilter> filters) {
        this.setFilters(filters);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribeKeywordsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public DescribeKeywordsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOriginationIdentity() != null) {
            sb.append("OriginationIdentity: ").append(this.getOriginationIdentity()).append(",");
        }
        if (this.getKeywords() != null) {
            sb.append("Keywords: ").append(this.getKeywords()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeKeywordsRequest)) {
            return false;
        }
        DescribeKeywordsRequest other = (DescribeKeywordsRequest)obj;
        if (other.getOriginationIdentity() == null ^ this.getOriginationIdentity() == null) {
            return false;
        }
        if (other.getOriginationIdentity() != null && !other.getOriginationIdentity().equals(this.getOriginationIdentity())) {
            return false;
        }
        if (other.getKeywords() == null ^ this.getKeywords() == null) {
            return false;
        }
        if (other.getKeywords() != null && !other.getKeywords().equals(this.getKeywords())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        return other.getMaxResults() == null || other.getMaxResults().equals(this.getMaxResults());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOriginationIdentity() == null ? 0 : this.getOriginationIdentity().hashCode());
        hashCode = 31 * hashCode + (this.getKeywords() == null ? 0 : this.getKeywords().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        return hashCode;
    }

    public DescribeKeywordsRequest clone() {
        return (DescribeKeywordsRequest)super.clone();
    }
}

