/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpointsmsvoicev2.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.pinpointsmsvoicev2.model.PoolInformation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribePoolsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<PoolInformation> pools;
    private String nextToken;

    public List<PoolInformation> getPools() {
        return this.pools;
    }

    public void setPools(Collection<PoolInformation> pools) {
        if (pools == null) {
            this.pools = null;
            return;
        }
        this.pools = new ArrayList<PoolInformation>(pools);
    }

    public DescribePoolsResult withPools(PoolInformation ... pools) {
        if (this.pools == null) {
            this.setPools(new ArrayList<PoolInformation>(pools.length));
        }
        for (PoolInformation ele : pools) {
            this.pools.add(ele);
        }
        return this;
    }

    public DescribePoolsResult withPools(Collection<PoolInformation> pools) {
        this.setPools(pools);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribePoolsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPools() != null) {
            sb.append("Pools: ").append(this.getPools()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePoolsResult)) {
            return false;
        }
        DescribePoolsResult other = (DescribePoolsResult)obj;
        if (other.getPools() == null ^ this.getPools() == null) {
            return false;
        }
        if (other.getPools() != null && !other.getPools().equals(this.getPools())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPools() == null ? 0 : this.getPools().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public DescribePoolsResult clone() {
        try {
            return (DescribePoolsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

