/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pinpoint.model.Event;
import com.amazonaws.services.pinpoint.model.PublicEndpoint;
import com.amazonaws.services.pinpoint.model.transform.EventsBatchMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class EventsBatch
implements Serializable,
Cloneable,
StructuredPojo {
    private PublicEndpoint endpoint;
    private Map<String, Event> events;

    public void setEndpoint(PublicEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public PublicEndpoint getEndpoint() {
        return this.endpoint;
    }

    public EventsBatch withEndpoint(PublicEndpoint endpoint) {
        this.setEndpoint(endpoint);
        return this;
    }

    public Map<String, Event> getEvents() {
        return this.events;
    }

    public void setEvents(Map<String, Event> events) {
        this.events = events;
    }

    public EventsBatch withEvents(Map<String, Event> events) {
        this.setEvents(events);
        return this;
    }

    public EventsBatch addEventsEntry(String key, Event value) {
        if (null == this.events) {
            this.events = new HashMap<String, Event>();
        }
        if (this.events.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.events.put(key, value);
        return this;
    }

    public EventsBatch clearEventsEntries() {
        this.events = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEndpoint() != null) {
            sb.append("Endpoint: ").append(this.getEndpoint()).append(",");
        }
        if (this.getEvents() != null) {
            sb.append("Events: ").append(this.getEvents());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventsBatch)) {
            return false;
        }
        EventsBatch other = (EventsBatch)obj;
        if (other.getEndpoint() == null ^ this.getEndpoint() == null) {
            return false;
        }
        if (other.getEndpoint() != null && !other.getEndpoint().equals(this.getEndpoint())) {
            return false;
        }
        if (other.getEvents() == null ^ this.getEvents() == null) {
            return false;
        }
        return other.getEvents() == null || other.getEvents().equals(this.getEvents());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEndpoint() == null ? 0 : this.getEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getEvents() == null ? 0 : this.getEvents().hashCode());
        return hashCode;
    }

    public EventsBatch clone() {
        try {
            return (EventsBatch)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventsBatchMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

