/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.pinpoint.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.pinpoint.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * JourneyLimitsMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class JourneyLimitsMarshaller {

    private static final MarshallingInfo<Integer> DAILYCAP_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DailyCap").build();
    private static final MarshallingInfo<Integer> ENDPOINTREENTRYCAP_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndpointReentryCap").build();
    private static final MarshallingInfo<Integer> MESSAGESPERSECOND_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MessagesPerSecond").build();
    private static final MarshallingInfo<String> ENDPOINTREENTRYINTERVAL_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndpointReentryInterval").build();
    private static final MarshallingInfo<StructuredPojo> TIMEFRAMECAP_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimeframeCap").build();
    private static final MarshallingInfo<Integer> TOTALCAP_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalCap").build();

    private static final JourneyLimitsMarshaller instance = new JourneyLimitsMarshaller();

    public static JourneyLimitsMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(JourneyLimits journeyLimits, ProtocolMarshaller protocolMarshaller) {

        if (journeyLimits == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(journeyLimits.getDailyCap(), DAILYCAP_BINDING);
            protocolMarshaller.marshall(journeyLimits.getEndpointReentryCap(), ENDPOINTREENTRYCAP_BINDING);
            protocolMarshaller.marshall(journeyLimits.getMessagesPerSecond(), MESSAGESPERSECOND_BINDING);
            protocolMarshaller.marshall(journeyLimits.getEndpointReentryInterval(), ENDPOINTREENTRYINTERVAL_BINDING);
            protocolMarshaller.marshall(journeyLimits.getTimeframeCap(), TIMEFRAMECAP_BINDING);
            protocolMarshaller.marshall(journeyLimits.getTotalCap(), TOTALCAP_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
