/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.pinpoint.model.EndpointRequest;
import com.amazonaws.services.pinpoint.model.transform.EndpointDemographicJsonMarshaller;
import com.amazonaws.services.pinpoint.model.transform.EndpointLocationJsonMarshaller;
import com.amazonaws.services.pinpoint.model.transform.EndpointUserJsonMarshaller;
import java.util.List;
import java.util.Map;

public class EndpointRequestJsonMarshaller {
    private static EndpointRequestJsonMarshaller instance;

    public void marshall(EndpointRequest endpointRequest, StructuredJsonGenerator jsonGenerator) {
        if (endpointRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, Double> metricsMap;
            Map<String, List<String>> attributesMap;
            jsonGenerator.writeStartObject();
            if (endpointRequest.getAddress() != null) {
                jsonGenerator.writeFieldName("Address").writeValue(endpointRequest.getAddress());
            }
            if ((attributesMap = endpointRequest.getAttributes()) != null) {
                jsonGenerator.writeFieldName("Attributes");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, List<String>> attributesMapValue : attributesMap.entrySet()) {
                    if (attributesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(attributesMapValue.getKey());
                    jsonGenerator.writeStartArray();
                    for (String attributesMapValueList : attributesMapValue.getValue()) {
                        if (attributesMapValueList == null) continue;
                        jsonGenerator.writeValue(attributesMapValueList);
                    }
                    jsonGenerator.writeEndArray();
                }
                jsonGenerator.writeEndObject();
            }
            if (endpointRequest.getChannelType() != null) {
                jsonGenerator.writeFieldName("ChannelType").writeValue(endpointRequest.getChannelType());
            }
            if (endpointRequest.getDemographic() != null) {
                jsonGenerator.writeFieldName("Demographic");
                EndpointDemographicJsonMarshaller.getInstance().marshall(endpointRequest.getDemographic(), jsonGenerator);
            }
            if (endpointRequest.getEffectiveDate() != null) {
                jsonGenerator.writeFieldName("EffectiveDate").writeValue(endpointRequest.getEffectiveDate());
            }
            if (endpointRequest.getEndpointStatus() != null) {
                jsonGenerator.writeFieldName("EndpointStatus").writeValue(endpointRequest.getEndpointStatus());
            }
            if (endpointRequest.getLocation() != null) {
                jsonGenerator.writeFieldName("Location");
                EndpointLocationJsonMarshaller.getInstance().marshall(endpointRequest.getLocation(), jsonGenerator);
            }
            if ((metricsMap = endpointRequest.getMetrics()) != null) {
                jsonGenerator.writeFieldName("Metrics");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, Double> metricsMapValue : metricsMap.entrySet()) {
                    if (metricsMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(metricsMapValue.getKey());
                    jsonGenerator.writeValue(metricsMapValue.getValue().doubleValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (endpointRequest.getOptOut() != null) {
                jsonGenerator.writeFieldName("OptOut").writeValue(endpointRequest.getOptOut());
            }
            if (endpointRequest.getRequestId() != null) {
                jsonGenerator.writeFieldName("RequestId").writeValue(endpointRequest.getRequestId());
            }
            if (endpointRequest.getUser() != null) {
                jsonGenerator.writeFieldName("User");
                EndpointUserJsonMarshaller.getInstance().marshall(endpointRequest.getUser(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static EndpointRequestJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EndpointRequestJsonMarshaller();
        }
        return instance;
    }
}

