/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.pinpoint.model.EndpointBatchItem;
import com.amazonaws.services.pinpoint.model.transform.EndpointDemographicJsonMarshaller;
import com.amazonaws.services.pinpoint.model.transform.EndpointLocationJsonMarshaller;
import com.amazonaws.services.pinpoint.model.transform.EndpointUserJsonMarshaller;
import java.util.List;
import java.util.Map;

public class EndpointBatchItemJsonMarshaller {
    private static EndpointBatchItemJsonMarshaller instance;

    public void marshall(EndpointBatchItem endpointBatchItem, StructuredJsonGenerator jsonGenerator) {
        if (endpointBatchItem == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, Double> metricsMap;
            Map<String, List<String>> attributesMap;
            jsonGenerator.writeStartObject();
            if (endpointBatchItem.getAddress() != null) {
                jsonGenerator.writeFieldName("Address").writeValue(endpointBatchItem.getAddress());
            }
            if ((attributesMap = endpointBatchItem.getAttributes()) != null) {
                jsonGenerator.writeFieldName("Attributes");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, List<String>> attributesMapValue : attributesMap.entrySet()) {
                    if (attributesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(attributesMapValue.getKey());
                    jsonGenerator.writeStartArray();
                    for (String attributesMapValueList : attributesMapValue.getValue()) {
                        if (attributesMapValueList == null) continue;
                        jsonGenerator.writeValue(attributesMapValueList);
                    }
                    jsonGenerator.writeEndArray();
                }
                jsonGenerator.writeEndObject();
            }
            if (endpointBatchItem.getChannelType() != null) {
                jsonGenerator.writeFieldName("ChannelType").writeValue(endpointBatchItem.getChannelType());
            }
            if (endpointBatchItem.getDemographic() != null) {
                jsonGenerator.writeFieldName("Demographic");
                EndpointDemographicJsonMarshaller.getInstance().marshall(endpointBatchItem.getDemographic(), jsonGenerator);
            }
            if (endpointBatchItem.getEffectiveDate() != null) {
                jsonGenerator.writeFieldName("EffectiveDate").writeValue(endpointBatchItem.getEffectiveDate());
            }
            if (endpointBatchItem.getEndpointStatus() != null) {
                jsonGenerator.writeFieldName("EndpointStatus").writeValue(endpointBatchItem.getEndpointStatus());
            }
            if (endpointBatchItem.getId() != null) {
                jsonGenerator.writeFieldName("Id").writeValue(endpointBatchItem.getId());
            }
            if (endpointBatchItem.getLocation() != null) {
                jsonGenerator.writeFieldName("Location");
                EndpointLocationJsonMarshaller.getInstance().marshall(endpointBatchItem.getLocation(), jsonGenerator);
            }
            if ((metricsMap = endpointBatchItem.getMetrics()) != null) {
                jsonGenerator.writeFieldName("Metrics");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, Double> metricsMapValue : metricsMap.entrySet()) {
                    if (metricsMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(metricsMapValue.getKey());
                    jsonGenerator.writeValue(metricsMapValue.getValue().doubleValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (endpointBatchItem.getOptOut() != null) {
                jsonGenerator.writeFieldName("OptOut").writeValue(endpointBatchItem.getOptOut());
            }
            if (endpointBatchItem.getRequestId() != null) {
                jsonGenerator.writeFieldName("RequestId").writeValue(endpointBatchItem.getRequestId());
            }
            if (endpointBatchItem.getUser() != null) {
                jsonGenerator.writeFieldName("User");
                EndpointUserJsonMarshaller.getInstance().marshall(endpointBatchItem.getUser(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static EndpointBatchItemJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EndpointBatchItemJsonMarshaller();
        }
        return instance;
    }
}

