/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.pinpoint.model.SegmentDemographics;
import com.amazonaws.services.pinpoint.model.transform.SetDimensionJsonMarshaller;

public class SegmentDemographicsJsonMarshaller {
    private static SegmentDemographicsJsonMarshaller instance;

    public void marshall(SegmentDemographics segmentDemographics, StructuredJsonGenerator jsonGenerator) {
        if (segmentDemographics == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (segmentDemographics.getAppVersion() != null) {
                jsonGenerator.writeFieldName("AppVersion");
                SetDimensionJsonMarshaller.getInstance().marshall(segmentDemographics.getAppVersion(), jsonGenerator);
            }
            if (segmentDemographics.getDeviceType() != null) {
                jsonGenerator.writeFieldName("DeviceType");
                SetDimensionJsonMarshaller.getInstance().marshall(segmentDemographics.getDeviceType(), jsonGenerator);
            }
            if (segmentDemographics.getMake() != null) {
                jsonGenerator.writeFieldName("Make");
                SetDimensionJsonMarshaller.getInstance().marshall(segmentDemographics.getMake(), jsonGenerator);
            }
            if (segmentDemographics.getModel() != null) {
                jsonGenerator.writeFieldName("Model");
                SetDimensionJsonMarshaller.getInstance().marshall(segmentDemographics.getModel(), jsonGenerator);
            }
            if (segmentDemographics.getPlatform() != null) {
                jsonGenerator.writeFieldName("Platform");
                SetDimensionJsonMarshaller.getInstance().marshall(segmentDemographics.getPlatform(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static SegmentDemographicsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new SegmentDemographicsJsonMarshaller();
        }
        return instance;
    }
}

