/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.pinpoint.model.EndpointLocation;

public class EndpointLocationJsonMarshaller {
    private static EndpointLocationJsonMarshaller instance;

    public void marshall(EndpointLocation endpointLocation, StructuredJsonGenerator jsonGenerator) {
        if (endpointLocation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (endpointLocation.getCity() != null) {
                jsonGenerator.writeFieldName("City").writeValue(endpointLocation.getCity());
            }
            if (endpointLocation.getCountry() != null) {
                jsonGenerator.writeFieldName("Country").writeValue(endpointLocation.getCountry());
            }
            if (endpointLocation.getLatitude() != null) {
                jsonGenerator.writeFieldName("Latitude").writeValue(endpointLocation.getLatitude().doubleValue());
            }
            if (endpointLocation.getLongitude() != null) {
                jsonGenerator.writeFieldName("Longitude").writeValue(endpointLocation.getLongitude().doubleValue());
            }
            if (endpointLocation.getPostalCode() != null) {
                jsonGenerator.writeFieldName("PostalCode").writeValue(endpointLocation.getPostalCode());
            }
            if (endpointLocation.getRegion() != null) {
                jsonGenerator.writeFieldName("Region").writeValue(endpointLocation.getRegion());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static EndpointLocationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EndpointLocationJsonMarshaller();
        }
        return instance;
    }
}

