/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.pinpoint.model.DeleteCampaignRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DeleteCampaignRequestMarshaller
implements Marshaller<Request<DeleteCampaignRequest>, DeleteCampaignRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DeleteCampaignRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DeleteCampaignRequest> marshall(DeleteCampaignRequest deleteCampaignRequest) {
        if (deleteCampaignRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteCampaignRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/v1/apps/{application-id}/campaigns/{campaign-id}";
        uriResourcePath = uriResourcePath.replace("{application-id}", deleteCampaignRequest.getApplicationId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)deleteCampaignRequest.getApplicationId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{campaign-id}", deleteCampaignRequest.getCampaignId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)deleteCampaignRequest.getCampaignId()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

