/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pinpoint.model.SegmentDimensions;
import com.amazonaws.services.pinpoint.model.SegmentReference;
import com.amazonaws.services.pinpoint.model.SourceType;
import com.amazonaws.services.pinpoint.model.Type;
import com.amazonaws.services.pinpoint.model.transform.SegmentGroupMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SegmentGroup
implements Serializable,
Cloneable,
StructuredPojo {
    private List<SegmentDimensions> dimensions;
    private List<SegmentReference> sourceSegments;
    private String sourceType;
    private String type;

    public List<SegmentDimensions> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Collection<SegmentDimensions> dimensions) {
        if (dimensions == null) {
            this.dimensions = null;
            return;
        }
        this.dimensions = new ArrayList<SegmentDimensions>(dimensions);
    }

    public SegmentGroup withDimensions(SegmentDimensions ... dimensions) {
        if (this.dimensions == null) {
            this.setDimensions(new ArrayList<SegmentDimensions>(dimensions.length));
        }
        for (SegmentDimensions ele : dimensions) {
            this.dimensions.add(ele);
        }
        return this;
    }

    public SegmentGroup withDimensions(Collection<SegmentDimensions> dimensions) {
        this.setDimensions(dimensions);
        return this;
    }

    public List<SegmentReference> getSourceSegments() {
        return this.sourceSegments;
    }

    public void setSourceSegments(Collection<SegmentReference> sourceSegments) {
        if (sourceSegments == null) {
            this.sourceSegments = null;
            return;
        }
        this.sourceSegments = new ArrayList<SegmentReference>(sourceSegments);
    }

    public SegmentGroup withSourceSegments(SegmentReference ... sourceSegments) {
        if (this.sourceSegments == null) {
            this.setSourceSegments(new ArrayList<SegmentReference>(sourceSegments.length));
        }
        for (SegmentReference ele : sourceSegments) {
            this.sourceSegments.add(ele);
        }
        return this;
    }

    public SegmentGroup withSourceSegments(Collection<SegmentReference> sourceSegments) {
        this.setSourceSegments(sourceSegments);
        return this;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public SegmentGroup withSourceType(String sourceType) {
        this.setSourceType(sourceType);
        return this;
    }

    public SegmentGroup withSourceType(SourceType sourceType) {
        this.sourceType = sourceType.toString();
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public SegmentGroup withType(String type) {
        this.setType(type);
        return this;
    }

    public SegmentGroup withType(Type type) {
        this.type = type.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDimensions() != null) {
            sb.append("Dimensions: ").append(this.getDimensions()).append(",");
        }
        if (this.getSourceSegments() != null) {
            sb.append("SourceSegments: ").append(this.getSourceSegments()).append(",");
        }
        if (this.getSourceType() != null) {
            sb.append("SourceType: ").append(this.getSourceType()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentGroup)) {
            return false;
        }
        SegmentGroup other = (SegmentGroup)obj;
        if (other.getDimensions() == null ^ this.getDimensions() == null) {
            return false;
        }
        if (other.getDimensions() != null && !other.getDimensions().equals(this.getDimensions())) {
            return false;
        }
        if (other.getSourceSegments() == null ^ this.getSourceSegments() == null) {
            return false;
        }
        if (other.getSourceSegments() != null && !other.getSourceSegments().equals(this.getSourceSegments())) {
            return false;
        }
        if (other.getSourceType() == null ^ this.getSourceType() == null) {
            return false;
        }
        if (other.getSourceType() != null && !other.getSourceType().equals(this.getSourceType())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        return other.getType() == null || other.getType().equals(this.getType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDimensions() == null ? 0 : this.getDimensions().hashCode());
        hashCode = 31 * hashCode + (this.getSourceSegments() == null ? 0 : this.getSourceSegments().hashCode());
        hashCode = 31 * hashCode + (this.getSourceType() == null ? 0 : this.getSourceType().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        return hashCode;
    }

    public SegmentGroup clone() {
        try {
            return (SegmentGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SegmentGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

