/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pinpoint.model.Action;
import com.amazonaws.services.pinpoint.model.transform.GCMMessageMarshaller;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GCMMessage
implements Serializable,
Cloneable,
StructuredPojo {
    private String action;
    private String body;
    private String collapseKey;
    private Map<String, String> data;
    private String iconReference;
    private String imageIconUrl;
    private String imageUrl;
    private String jsonData;
    private String rawContent;
    private String restrictedPackageName;
    private Boolean silentPush;
    private String smallImageIconUrl;
    private String sound;
    private Map<String, List<String>> substitutions;
    private String title;
    private String url;

    public void setAction(String action) {
        this.action = action;
    }

    @JsonProperty(value="action")
    public String getAction() {
        return this.action;
    }

    public GCMMessage withAction(String action) {
        this.setAction(action);
        return this;
    }

    @JsonIgnore
    public void setAction(Action action) {
        this.withAction(action);
    }

    public GCMMessage withAction(Action action) {
        this.action = action.toString();
        return this;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getBody() {
        return this.body;
    }

    public GCMMessage withBody(String body) {
        this.setBody(body);
        return this;
    }

    public void setCollapseKey(String collapseKey) {
        this.collapseKey = collapseKey;
    }

    public String getCollapseKey() {
        return this.collapseKey;
    }

    public GCMMessage withCollapseKey(String collapseKey) {
        this.setCollapseKey(collapseKey);
        return this;
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public void setData(Map<String, String> data) {
        this.data = data;
    }

    public GCMMessage withData(Map<String, String> data) {
        this.setData(data);
        return this;
    }

    public GCMMessage addDataEntry(String key, String value) {
        if (null == this.data) {
            this.data = new HashMap<String, String>();
        }
        if (this.data.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.data.put(key, value);
        return this;
    }

    public GCMMessage clearDataEntries() {
        this.data = null;
        return this;
    }

    public void setIconReference(String iconReference) {
        this.iconReference = iconReference;
    }

    public String getIconReference() {
        return this.iconReference;
    }

    public GCMMessage withIconReference(String iconReference) {
        this.setIconReference(iconReference);
        return this;
    }

    public void setImageIconUrl(String imageIconUrl) {
        this.imageIconUrl = imageIconUrl;
    }

    public String getImageIconUrl() {
        return this.imageIconUrl;
    }

    public GCMMessage withImageIconUrl(String imageIconUrl) {
        this.setImageIconUrl(imageIconUrl);
        return this;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public GCMMessage withImageUrl(String imageUrl) {
        this.setImageUrl(imageUrl);
        return this;
    }

    public void setJsonData(String jsonData) {
        this.jsonData = jsonData;
    }

    public String getJsonData() {
        return this.jsonData;
    }

    public GCMMessage withJsonData(String jsonData) {
        this.setJsonData(jsonData);
        return this;
    }

    public void setRawContent(String rawContent) {
        this.rawContent = rawContent;
    }

    public String getRawContent() {
        return this.rawContent;
    }

    public GCMMessage withRawContent(String rawContent) {
        this.setRawContent(rawContent);
        return this;
    }

    public void setRestrictedPackageName(String restrictedPackageName) {
        this.restrictedPackageName = restrictedPackageName;
    }

    public String getRestrictedPackageName() {
        return this.restrictedPackageName;
    }

    public GCMMessage withRestrictedPackageName(String restrictedPackageName) {
        this.setRestrictedPackageName(restrictedPackageName);
        return this;
    }

    public void setSilentPush(Boolean silentPush) {
        this.silentPush = silentPush;
    }

    public Boolean getSilentPush() {
        return this.silentPush;
    }

    public GCMMessage withSilentPush(Boolean silentPush) {
        this.setSilentPush(silentPush);
        return this;
    }

    public Boolean isSilentPush() {
        return this.silentPush;
    }

    public void setSmallImageIconUrl(String smallImageIconUrl) {
        this.smallImageIconUrl = smallImageIconUrl;
    }

    public String getSmallImageIconUrl() {
        return this.smallImageIconUrl;
    }

    public GCMMessage withSmallImageIconUrl(String smallImageIconUrl) {
        this.setSmallImageIconUrl(smallImageIconUrl);
        return this;
    }

    public void setSound(String sound) {
        this.sound = sound;
    }

    public String getSound() {
        return this.sound;
    }

    public GCMMessage withSound(String sound) {
        this.setSound(sound);
        return this;
    }

    public Map<String, List<String>> getSubstitutions() {
        return this.substitutions;
    }

    public void setSubstitutions(Map<String, List<String>> substitutions) {
        this.substitutions = substitutions;
    }

    public GCMMessage withSubstitutions(Map<String, List<String>> substitutions) {
        this.setSubstitutions(substitutions);
        return this;
    }

    public GCMMessage addSubstitutionsEntry(String key, List<String> value) {
        if (null == this.substitutions) {
            this.substitutions = new HashMap<String, List<String>>();
        }
        if (this.substitutions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.substitutions.put(key, value);
        return this;
    }

    public GCMMessage clearSubstitutionsEntries() {
        this.substitutions = null;
        return this;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public GCMMessage withTitle(String title) {
        this.setTitle(title);
        return this;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public GCMMessage withUrl(String url) {
        this.setUrl(url);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAction() != null) {
            sb.append("Action: ").append(this.getAction()).append(",");
        }
        if (this.getBody() != null) {
            sb.append("Body: ").append(this.getBody()).append(",");
        }
        if (this.getCollapseKey() != null) {
            sb.append("CollapseKey: ").append(this.getCollapseKey()).append(",");
        }
        if (this.getData() != null) {
            sb.append("Data: ").append(this.getData()).append(",");
        }
        if (this.getIconReference() != null) {
            sb.append("IconReference: ").append(this.getIconReference()).append(",");
        }
        if (this.getImageIconUrl() != null) {
            sb.append("ImageIconUrl: ").append(this.getImageIconUrl()).append(",");
        }
        if (this.getImageUrl() != null) {
            sb.append("ImageUrl: ").append(this.getImageUrl()).append(",");
        }
        if (this.getJsonData() != null) {
            sb.append("JsonData: ").append(this.getJsonData()).append(",");
        }
        if (this.getRawContent() != null) {
            sb.append("RawContent: ").append(this.getRawContent()).append(",");
        }
        if (this.getRestrictedPackageName() != null) {
            sb.append("RestrictedPackageName: ").append(this.getRestrictedPackageName()).append(",");
        }
        if (this.getSilentPush() != null) {
            sb.append("SilentPush: ").append(this.getSilentPush()).append(",");
        }
        if (this.getSmallImageIconUrl() != null) {
            sb.append("SmallImageIconUrl: ").append(this.getSmallImageIconUrl()).append(",");
        }
        if (this.getSound() != null) {
            sb.append("Sound: ").append(this.getSound()).append(",");
        }
        if (this.getSubstitutions() != null) {
            sb.append("Substitutions: ").append(this.getSubstitutions()).append(",");
        }
        if (this.getTitle() != null) {
            sb.append("Title: ").append(this.getTitle()).append(",");
        }
        if (this.getUrl() != null) {
            sb.append("Url: ").append(this.getUrl());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GCMMessage)) {
            return false;
        }
        GCMMessage other = (GCMMessage)obj;
        if (other.getAction() == null ^ this.getAction() == null) {
            return false;
        }
        if (other.getAction() != null && !other.getAction().equals(this.getAction())) {
            return false;
        }
        if (other.getBody() == null ^ this.getBody() == null) {
            return false;
        }
        if (other.getBody() != null && !other.getBody().equals(this.getBody())) {
            return false;
        }
        if (other.getCollapseKey() == null ^ this.getCollapseKey() == null) {
            return false;
        }
        if (other.getCollapseKey() != null && !other.getCollapseKey().equals(this.getCollapseKey())) {
            return false;
        }
        if (other.getData() == null ^ this.getData() == null) {
            return false;
        }
        if (other.getData() != null && !other.getData().equals(this.getData())) {
            return false;
        }
        if (other.getIconReference() == null ^ this.getIconReference() == null) {
            return false;
        }
        if (other.getIconReference() != null && !other.getIconReference().equals(this.getIconReference())) {
            return false;
        }
        if (other.getImageIconUrl() == null ^ this.getImageIconUrl() == null) {
            return false;
        }
        if (other.getImageIconUrl() != null && !other.getImageIconUrl().equals(this.getImageIconUrl())) {
            return false;
        }
        if (other.getImageUrl() == null ^ this.getImageUrl() == null) {
            return false;
        }
        if (other.getImageUrl() != null && !other.getImageUrl().equals(this.getImageUrl())) {
            return false;
        }
        if (other.getJsonData() == null ^ this.getJsonData() == null) {
            return false;
        }
        if (other.getJsonData() != null && !other.getJsonData().equals(this.getJsonData())) {
            return false;
        }
        if (other.getRawContent() == null ^ this.getRawContent() == null) {
            return false;
        }
        if (other.getRawContent() != null && !other.getRawContent().equals(this.getRawContent())) {
            return false;
        }
        if (other.getRestrictedPackageName() == null ^ this.getRestrictedPackageName() == null) {
            return false;
        }
        if (other.getRestrictedPackageName() != null && !other.getRestrictedPackageName().equals(this.getRestrictedPackageName())) {
            return false;
        }
        if (other.getSilentPush() == null ^ this.getSilentPush() == null) {
            return false;
        }
        if (other.getSilentPush() != null && !other.getSilentPush().equals(this.getSilentPush())) {
            return false;
        }
        if (other.getSmallImageIconUrl() == null ^ this.getSmallImageIconUrl() == null) {
            return false;
        }
        if (other.getSmallImageIconUrl() != null && !other.getSmallImageIconUrl().equals(this.getSmallImageIconUrl())) {
            return false;
        }
        if (other.getSound() == null ^ this.getSound() == null) {
            return false;
        }
        if (other.getSound() != null && !other.getSound().equals(this.getSound())) {
            return false;
        }
        if (other.getSubstitutions() == null ^ this.getSubstitutions() == null) {
            return false;
        }
        if (other.getSubstitutions() != null && !other.getSubstitutions().equals(this.getSubstitutions())) {
            return false;
        }
        if (other.getTitle() == null ^ this.getTitle() == null) {
            return false;
        }
        if (other.getTitle() != null && !other.getTitle().equals(this.getTitle())) {
            return false;
        }
        if (other.getUrl() == null ^ this.getUrl() == null) {
            return false;
        }
        return other.getUrl() == null || other.getUrl().equals(this.getUrl());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAction() == null ? 0 : this.getAction().hashCode());
        hashCode = 31 * hashCode + (this.getBody() == null ? 0 : this.getBody().hashCode());
        hashCode = 31 * hashCode + (this.getCollapseKey() == null ? 0 : this.getCollapseKey().hashCode());
        hashCode = 31 * hashCode + (this.getData() == null ? 0 : this.getData().hashCode());
        hashCode = 31 * hashCode + (this.getIconReference() == null ? 0 : this.getIconReference().hashCode());
        hashCode = 31 * hashCode + (this.getImageIconUrl() == null ? 0 : this.getImageIconUrl().hashCode());
        hashCode = 31 * hashCode + (this.getImageUrl() == null ? 0 : this.getImageUrl().hashCode());
        hashCode = 31 * hashCode + (this.getJsonData() == null ? 0 : this.getJsonData().hashCode());
        hashCode = 31 * hashCode + (this.getRawContent() == null ? 0 : this.getRawContent().hashCode());
        hashCode = 31 * hashCode + (this.getRestrictedPackageName() == null ? 0 : this.getRestrictedPackageName().hashCode());
        hashCode = 31 * hashCode + (this.getSilentPush() == null ? 0 : this.getSilentPush().hashCode());
        hashCode = 31 * hashCode + (this.getSmallImageIconUrl() == null ? 0 : this.getSmallImageIconUrl().hashCode());
        hashCode = 31 * hashCode + (this.getSound() == null ? 0 : this.getSound().hashCode());
        hashCode = 31 * hashCode + (this.getSubstitutions() == null ? 0 : this.getSubstitutions().hashCode());
        hashCode = 31 * hashCode + (this.getTitle() == null ? 0 : this.getTitle().hashCode());
        hashCode = 31 * hashCode + (this.getUrl() == null ? 0 : this.getUrl().hashCode());
        return hashCode;
    }

    public GCMMessage clone() {
        try {
            return (GCMMessage)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GCMMessageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

