/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.pinpoint.model.APNSChannelRequest;

@SdkInternalApi
public class APNSChannelRequestMarshaller {
    private static final MarshallingInfo<String> CERTIFICATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Certificate").build();
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").build();
    private static final MarshallingInfo<String> PRIVATEKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PrivateKey").build();
    private static final APNSChannelRequestMarshaller instance = new APNSChannelRequestMarshaller();

    public static APNSChannelRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(APNSChannelRequest aPNSChannelRequest, ProtocolMarshaller protocolMarshaller) {
        if (aPNSChannelRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)aPNSChannelRequest.getCertificate(), CERTIFICATE_BINDING);
            protocolMarshaller.marshall((Object)aPNSChannelRequest.getEnabled(), ENABLED_BINDING);
            protocolMarshaller.marshall((Object)aPNSChannelRequest.getPrivateKey(), PRIVATEKEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

