/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.personalizeruntime.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.personalizeruntime.model.transform.PredictedItemMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class PredictedItem
implements Serializable,
Cloneable,
StructuredPojo {
    private String itemId;
    private Double score;
    private String promotionName;
    private Map<String, String> metadata;

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public String getItemId() {
        return this.itemId;
    }

    public PredictedItem withItemId(String itemId) {
        this.setItemId(itemId);
        return this;
    }

    public void setScore(Double score) {
        this.score = score;
    }

    public Double getScore() {
        return this.score;
    }

    public PredictedItem withScore(Double score) {
        this.setScore(score);
        return this;
    }

    public void setPromotionName(String promotionName) {
        this.promotionName = promotionName;
    }

    public String getPromotionName() {
        return this.promotionName;
    }

    public PredictedItem withPromotionName(String promotionName) {
        this.setPromotionName(promotionName);
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public PredictedItem withMetadata(Map<String, String> metadata) {
        this.setMetadata(metadata);
        return this;
    }

    public PredictedItem addMetadataEntry(String key, String value) {
        if (null == this.metadata) {
            this.metadata = new HashMap<String, String>();
        }
        if (this.metadata.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.metadata.put(key, value);
        return this;
    }

    public PredictedItem clearMetadataEntries() {
        this.metadata = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getItemId() != null) {
            sb.append("ItemId: ").append(this.getItemId()).append(",");
        }
        if (this.getScore() != null) {
            sb.append("Score: ").append(this.getScore()).append(",");
        }
        if (this.getPromotionName() != null) {
            sb.append("PromotionName: ").append(this.getPromotionName()).append(",");
        }
        if (this.getMetadata() != null) {
            sb.append("Metadata: ").append(this.getMetadata());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictedItem)) {
            return false;
        }
        PredictedItem other = (PredictedItem)obj;
        if (other.getItemId() == null ^ this.getItemId() == null) {
            return false;
        }
        if (other.getItemId() != null && !other.getItemId().equals(this.getItemId())) {
            return false;
        }
        if (other.getScore() == null ^ this.getScore() == null) {
            return false;
        }
        if (other.getScore() != null && !other.getScore().equals(this.getScore())) {
            return false;
        }
        if (other.getPromotionName() == null ^ this.getPromotionName() == null) {
            return false;
        }
        if (other.getPromotionName() != null && !other.getPromotionName().equals(this.getPromotionName())) {
            return false;
        }
        if (other.getMetadata() == null ^ this.getMetadata() == null) {
            return false;
        }
        return other.getMetadata() == null || other.getMetadata().equals(this.getMetadata());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getItemId() == null ? 0 : this.getItemId().hashCode());
        hashCode = 31 * hashCode + (this.getScore() == null ? 0 : this.getScore().hashCode());
        hashCode = 31 * hashCode + (this.getPromotionName() == null ? 0 : this.getPromotionName().hashCode());
        hashCode = 31 * hashCode + (this.getMetadata() == null ? 0 : this.getMetadata().hashCode());
        return hashCode;
    }

    public PredictedItem clone() {
        try {
            return (PredictedItem)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PredictedItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

