/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.personalize.model.transform;

import java.util.Map;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.personalize.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * RecommenderConfigMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class RecommenderConfigMarshaller {

    private static final MarshallingInfo<Map> ITEMEXPLORATIONCONFIG_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("itemExplorationConfig").build();
    private static final MarshallingInfo<Integer> MINRECOMMENDATIONREQUESTSPERSECOND_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minRecommendationRequestsPerSecond").build();
    private static final MarshallingInfo<StructuredPojo> TRAININGDATACONFIG_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("trainingDataConfig").build();
    private static final MarshallingInfo<Boolean> ENABLEMETADATAWITHRECOMMENDATIONS_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("enableMetadataWithRecommendations").build();

    private static final RecommenderConfigMarshaller instance = new RecommenderConfigMarshaller();

    public static RecommenderConfigMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(RecommenderConfig recommenderConfig, ProtocolMarshaller protocolMarshaller) {

        if (recommenderConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(recommenderConfig.getItemExplorationConfig(), ITEMEXPLORATIONCONFIG_BINDING);
            protocolMarshaller.marshall(recommenderConfig.getMinRecommendationRequestsPerSecond(), MINRECOMMENDATIONREQUESTSPERSECOND_BINDING);
            protocolMarshaller.marshall(recommenderConfig.getTrainingDataConfig(), TRAININGDATACONFIG_BINDING);
            protocolMarshaller.marshall(recommenderConfig.getEnableMetadataWithRecommendations(), ENABLEMETADATAWITHRECOMMENDATIONS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
