/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.personalize.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.personalize.model.SolutionVersion;
import java.util.Date;

@SdkInternalApi
public class SolutionVersionMarshaller {
    private static final MarshallingInfo<String> SOLUTIONVERSIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("solutionVersionArn").build();
    private static final MarshallingInfo<String> SOLUTIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("solutionArn").build();
    private static final MarshallingInfo<Boolean> PERFORMHPO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("performHPO").build();
    private static final MarshallingInfo<Boolean> PERFORMAUTOML_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("performAutoML").build();
    private static final MarshallingInfo<String> RECIPEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("recipeArn").build();
    private static final MarshallingInfo<String> EVENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventType").build();
    private static final MarshallingInfo<String> DATASETGROUPARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("datasetGroupArn").build();
    private static final MarshallingInfo<StructuredPojo> SOLUTIONCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("solutionConfig").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<String> FAILUREREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("failureReason").build();
    private static final MarshallingInfo<Date> CREATIONDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationDateTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTUPDATEDDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedDateTime").timestampFormat("unixTimestamp").build();
    private static final SolutionVersionMarshaller instance = new SolutionVersionMarshaller();

    public static SolutionVersionMarshaller getInstance() {
        return instance;
    }

    public void marshall(SolutionVersion solutionVersion, ProtocolMarshaller protocolMarshaller) {
        if (solutionVersion == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)solutionVersion.getSolutionVersionArn(), SOLUTIONVERSIONARN_BINDING);
            protocolMarshaller.marshall((Object)solutionVersion.getSolutionArn(), SOLUTIONARN_BINDING);
            protocolMarshaller.marshall((Object)solutionVersion.getPerformHPO(), PERFORMHPO_BINDING);
            protocolMarshaller.marshall((Object)solutionVersion.getPerformAutoML(), PERFORMAUTOML_BINDING);
            protocolMarshaller.marshall((Object)solutionVersion.getRecipeArn(), RECIPEARN_BINDING);
            protocolMarshaller.marshall((Object)solutionVersion.getEventType(), EVENTTYPE_BINDING);
            protocolMarshaller.marshall((Object)solutionVersion.getDatasetGroupArn(), DATASETGROUPARN_BINDING);
            protocolMarshaller.marshall((Object)solutionVersion.getSolutionConfig(), SOLUTIONCONFIG_BINDING);
            protocolMarshaller.marshall((Object)solutionVersion.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)solutionVersion.getFailureReason(), FAILUREREASON_BINDING);
            protocolMarshaller.marshall((Object)solutionVersion.getCreationDateTime(), CREATIONDATETIME_BINDING);
            protocolMarshaller.marshall((Object)solutionVersion.getLastUpdatedDateTime(), LASTUPDATEDDATETIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

