/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.paymentcryptography;

import javax.annotation.Generated;

import com.amazonaws.services.paymentcryptography.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSPaymentCryptography}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSPaymentCryptography implements AWSPaymentCryptography {

    protected AbstractAWSPaymentCryptography() {
    }

    @Override
    public CreateAliasResult createAlias(CreateAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateKeyResult createKey(CreateKeyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAliasResult deleteAlias(DeleteAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteKeyResult deleteKey(DeleteKeyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ExportKeyResult exportKey(ExportKeyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAliasResult getAlias(GetAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetKeyResult getKey(GetKeyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetParametersForExportResult getParametersForExport(GetParametersForExportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetParametersForImportResult getParametersForImport(GetParametersForImportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPublicKeyCertificateResult getPublicKeyCertificate(GetPublicKeyCertificateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ImportKeyResult importKey(ImportKeyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAliasesResult listAliases(ListAliasesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListKeysResult listKeys(ListKeysRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RestoreKeyResult restoreKey(RestoreKeyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartKeyUsageResult startKeyUsage(StartKeyUsageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopKeyUsageResult stopKeyUsage(StopKeyUsageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAliasResult updateAlias(UpdateAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
