/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.paymentcryptography.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.paymentcryptography.model.ExportKeyRequest;

@SdkInternalApi
public class ExportKeyRequestMarshaller {
    private static final MarshallingInfo<StructuredPojo> KEYMATERIAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyMaterial").build();
    private static final MarshallingInfo<String> EXPORTKEYIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExportKeyIdentifier").build();
    private static final MarshallingInfo<StructuredPojo> EXPORTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExportAttributes").build();
    private static final ExportKeyRequestMarshaller instance = new ExportKeyRequestMarshaller();

    public static ExportKeyRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(ExportKeyRequest exportKeyRequest, ProtocolMarshaller protocolMarshaller) {
        if (exportKeyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)exportKeyRequest.getKeyMaterial(), KEYMATERIAL_BINDING);
            protocolMarshaller.marshall((Object)exportKeyRequest.getExportKeyIdentifier(), EXPORTKEYIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)exportKeyRequest.getExportAttributes(), EXPORTATTRIBUTES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

