/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.paymentcryptography.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.paymentcryptography.model.KeyAttributes;

@SdkInternalApi
public class KeyAttributesMarshaller {
    private static final MarshallingInfo<String> KEYALGORITHM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyAlgorithm").build();
    private static final MarshallingInfo<String> KEYCLASS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyClass").build();
    private static final MarshallingInfo<StructuredPojo> KEYMODESOFUSE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyModesOfUse").build();
    private static final MarshallingInfo<String> KEYUSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyUsage").build();
    private static final KeyAttributesMarshaller instance = new KeyAttributesMarshaller();

    public static KeyAttributesMarshaller getInstance() {
        return instance;
    }

    public void marshall(KeyAttributes keyAttributes, ProtocolMarshaller protocolMarshaller) {
        if (keyAttributes == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)keyAttributes.getKeyAlgorithm(), KEYALGORITHM_BINDING);
            protocolMarshaller.marshall((Object)keyAttributes.getKeyClass(), KEYCLASS_BINDING);
            protocolMarshaller.marshall((Object)keyAttributes.getKeyModesOfUse(), KEYMODESOFUSE_BINDING);
            protocolMarshaller.marshall((Object)keyAttributes.getKeyUsage(), KEYUSAGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

