/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.panorama.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.panorama.model.NodeInputPort;
import com.amazonaws.services.panorama.model.NodeOutputPort;
import com.amazonaws.services.panorama.model.transform.NodeInterfaceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NodeInterface
implements Serializable,
Cloneable,
StructuredPojo {
    private List<NodeInputPort> inputs;
    private List<NodeOutputPort> outputs;

    public List<NodeInputPort> getInputs() {
        return this.inputs;
    }

    public void setInputs(Collection<NodeInputPort> inputs) {
        if (inputs == null) {
            this.inputs = null;
            return;
        }
        this.inputs = new ArrayList<NodeInputPort>(inputs);
    }

    public NodeInterface withInputs(NodeInputPort ... inputs) {
        if (this.inputs == null) {
            this.setInputs(new ArrayList<NodeInputPort>(inputs.length));
        }
        for (NodeInputPort ele : inputs) {
            this.inputs.add(ele);
        }
        return this;
    }

    public NodeInterface withInputs(Collection<NodeInputPort> inputs) {
        this.setInputs(inputs);
        return this;
    }

    public List<NodeOutputPort> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(Collection<NodeOutputPort> outputs) {
        if (outputs == null) {
            this.outputs = null;
            return;
        }
        this.outputs = new ArrayList<NodeOutputPort>(outputs);
    }

    public NodeInterface withOutputs(NodeOutputPort ... outputs) {
        if (this.outputs == null) {
            this.setOutputs(new ArrayList<NodeOutputPort>(outputs.length));
        }
        for (NodeOutputPort ele : outputs) {
            this.outputs.add(ele);
        }
        return this;
    }

    public NodeInterface withOutputs(Collection<NodeOutputPort> outputs) {
        this.setOutputs(outputs);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInputs() != null) {
            sb.append("Inputs: ").append(this.getInputs()).append(",");
        }
        if (this.getOutputs() != null) {
            sb.append("Outputs: ").append(this.getOutputs());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeInterface)) {
            return false;
        }
        NodeInterface other = (NodeInterface)obj;
        if (other.getInputs() == null ^ this.getInputs() == null) {
            return false;
        }
        if (other.getInputs() != null && !other.getInputs().equals(this.getInputs())) {
            return false;
        }
        if (other.getOutputs() == null ^ this.getOutputs() == null) {
            return false;
        }
        return other.getOutputs() == null || other.getOutputs().equals(this.getOutputs());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInputs() == null ? 0 : this.getInputs().hashCode());
        hashCode = 31 * hashCode + (this.getOutputs() == null ? 0 : this.getOutputs().hashCode());
        return hashCode;
    }

    public NodeInterface clone() {
        try {
            return (NodeInterface)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NodeInterfaceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

