/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.osis;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.osis.AmazonOSIS;
import com.amazonaws.services.osis.AmazonOSISClientBuilder;
import com.amazonaws.services.osis.model.AmazonOSISException;
import com.amazonaws.services.osis.model.CreatePipelineRequest;
import com.amazonaws.services.osis.model.CreatePipelineResult;
import com.amazonaws.services.osis.model.DeletePipelineRequest;
import com.amazonaws.services.osis.model.DeletePipelineResult;
import com.amazonaws.services.osis.model.GetPipelineBlueprintRequest;
import com.amazonaws.services.osis.model.GetPipelineBlueprintResult;
import com.amazonaws.services.osis.model.GetPipelineChangeProgressRequest;
import com.amazonaws.services.osis.model.GetPipelineChangeProgressResult;
import com.amazonaws.services.osis.model.GetPipelineRequest;
import com.amazonaws.services.osis.model.GetPipelineResult;
import com.amazonaws.services.osis.model.ListPipelineBlueprintsRequest;
import com.amazonaws.services.osis.model.ListPipelineBlueprintsResult;
import com.amazonaws.services.osis.model.ListPipelinesRequest;
import com.amazonaws.services.osis.model.ListPipelinesResult;
import com.amazonaws.services.osis.model.ListTagsForResourceRequest;
import com.amazonaws.services.osis.model.ListTagsForResourceResult;
import com.amazonaws.services.osis.model.StartPipelineRequest;
import com.amazonaws.services.osis.model.StartPipelineResult;
import com.amazonaws.services.osis.model.StopPipelineRequest;
import com.amazonaws.services.osis.model.StopPipelineResult;
import com.amazonaws.services.osis.model.TagResourceRequest;
import com.amazonaws.services.osis.model.TagResourceResult;
import com.amazonaws.services.osis.model.UntagResourceRequest;
import com.amazonaws.services.osis.model.UntagResourceResult;
import com.amazonaws.services.osis.model.UpdatePipelineRequest;
import com.amazonaws.services.osis.model.UpdatePipelineResult;
import com.amazonaws.services.osis.model.ValidatePipelineRequest;
import com.amazonaws.services.osis.model.ValidatePipelineResult;
import com.amazonaws.services.osis.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.osis.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.osis.model.transform.CreatePipelineRequestProtocolMarshaller;
import com.amazonaws.services.osis.model.transform.CreatePipelineResultJsonUnmarshaller;
import com.amazonaws.services.osis.model.transform.DeletePipelineRequestProtocolMarshaller;
import com.amazonaws.services.osis.model.transform.DeletePipelineResultJsonUnmarshaller;
import com.amazonaws.services.osis.model.transform.DisabledOperationExceptionUnmarshaller;
import com.amazonaws.services.osis.model.transform.GetPipelineBlueprintRequestProtocolMarshaller;
import com.amazonaws.services.osis.model.transform.GetPipelineBlueprintResultJsonUnmarshaller;
import com.amazonaws.services.osis.model.transform.GetPipelineChangeProgressRequestProtocolMarshaller;
import com.amazonaws.services.osis.model.transform.GetPipelineChangeProgressResultJsonUnmarshaller;
import com.amazonaws.services.osis.model.transform.GetPipelineRequestProtocolMarshaller;
import com.amazonaws.services.osis.model.transform.GetPipelineResultJsonUnmarshaller;
import com.amazonaws.services.osis.model.transform.InternalExceptionUnmarshaller;
import com.amazonaws.services.osis.model.transform.InvalidPaginationTokenExceptionUnmarshaller;
import com.amazonaws.services.osis.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.osis.model.transform.ListPipelineBlueprintsRequestProtocolMarshaller;
import com.amazonaws.services.osis.model.transform.ListPipelineBlueprintsResultJsonUnmarshaller;
import com.amazonaws.services.osis.model.transform.ListPipelinesRequestProtocolMarshaller;
import com.amazonaws.services.osis.model.transform.ListPipelinesResultJsonUnmarshaller;
import com.amazonaws.services.osis.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.osis.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.osis.model.transform.ResourceAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.osis.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.osis.model.transform.StartPipelineRequestProtocolMarshaller;
import com.amazonaws.services.osis.model.transform.StartPipelineResultJsonUnmarshaller;
import com.amazonaws.services.osis.model.transform.StopPipelineRequestProtocolMarshaller;
import com.amazonaws.services.osis.model.transform.StopPipelineResultJsonUnmarshaller;
import com.amazonaws.services.osis.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.osis.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.osis.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.osis.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.osis.model.transform.UpdatePipelineRequestProtocolMarshaller;
import com.amazonaws.services.osis.model.transform.UpdatePipelineResultJsonUnmarshaller;
import com.amazonaws.services.osis.model.transform.ValidatePipelineRequestProtocolMarshaller;
import com.amazonaws.services.osis.model.transform.ValidatePipelineResultJsonUnmarshaller;
import com.amazonaws.services.osis.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonOSISClient
extends AmazonWebServiceClient
implements AmazonOSIS {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonOSIS.class);
    private static final String DEFAULT_SIGNING_NAME = "osis";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DisabledOperationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)DisabledOperationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceAlreadyExistsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceAlreadyExistsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidPaginationTokenException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidPaginationTokenExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)LimitExceededExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonOSISException.class));

    public static AmazonOSISClientBuilder builder() {
        return AmazonOSISClientBuilder.standard();
    }

    AmazonOSISClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonOSISClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("osis.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/osis/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/osis/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreatePipelineResult createPipeline(CreatePipelineRequest request) {
        request = (CreatePipelineRequest)this.beforeClientExecution(request);
        return this.executeCreatePipeline(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreatePipelineResult executeCreatePipeline(CreatePipelineRequest createPipelineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createPipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePipelineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreatePipelineRequestProtocolMarshaller(protocolFactory).marshall((CreatePipelineRequest)super.beforeMarshalling((AmazonWebServiceRequest)createPipelineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"OSIS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreatePipeline");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreatePipelineResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreatePipelineResult createPipelineResult = (CreatePipelineResult)response.getAwsResponse();
            return createPipelineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeletePipelineResult deletePipeline(DeletePipelineRequest request) {
        request = (DeletePipelineRequest)this.beforeClientExecution(request);
        return this.executeDeletePipeline(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeletePipelineResult executeDeletePipeline(DeletePipelineRequest deletePipelineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deletePipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeletePipelineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeletePipelineRequestProtocolMarshaller(protocolFactory).marshall((DeletePipelineRequest)super.beforeMarshalling((AmazonWebServiceRequest)deletePipelineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"OSIS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeletePipeline");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeletePipelineResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeletePipelineResult deletePipelineResult = (DeletePipelineResult)response.getAwsResponse();
            return deletePipelineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetPipelineResult getPipeline(GetPipelineRequest request) {
        request = (GetPipelineRequest)this.beforeClientExecution(request);
        return this.executeGetPipeline(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetPipelineResult executeGetPipeline(GetPipelineRequest getPipelineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getPipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetPipelineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetPipelineRequestProtocolMarshaller(protocolFactory).marshall((GetPipelineRequest)super.beforeMarshalling((AmazonWebServiceRequest)getPipelineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"OSIS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetPipeline");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetPipelineResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetPipelineResult getPipelineResult = (GetPipelineResult)response.getAwsResponse();
            return getPipelineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetPipelineBlueprintResult getPipelineBlueprint(GetPipelineBlueprintRequest request) {
        request = (GetPipelineBlueprintRequest)this.beforeClientExecution(request);
        return this.executeGetPipelineBlueprint(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetPipelineBlueprintResult executeGetPipelineBlueprint(GetPipelineBlueprintRequest getPipelineBlueprintRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getPipelineBlueprintRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetPipelineBlueprintRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetPipelineBlueprintRequestProtocolMarshaller(protocolFactory).marshall((GetPipelineBlueprintRequest)super.beforeMarshalling((AmazonWebServiceRequest)getPipelineBlueprintRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"OSIS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetPipelineBlueprint");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetPipelineBlueprintResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetPipelineBlueprintResult getPipelineBlueprintResult = (GetPipelineBlueprintResult)response.getAwsResponse();
            return getPipelineBlueprintResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetPipelineChangeProgressResult getPipelineChangeProgress(GetPipelineChangeProgressRequest request) {
        request = (GetPipelineChangeProgressRequest)this.beforeClientExecution(request);
        return this.executeGetPipelineChangeProgress(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetPipelineChangeProgressResult executeGetPipelineChangeProgress(GetPipelineChangeProgressRequest getPipelineChangeProgressRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getPipelineChangeProgressRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetPipelineChangeProgressRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetPipelineChangeProgressRequestProtocolMarshaller(protocolFactory).marshall((GetPipelineChangeProgressRequest)super.beforeMarshalling((AmazonWebServiceRequest)getPipelineChangeProgressRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"OSIS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetPipelineChangeProgress");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetPipelineChangeProgressResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetPipelineChangeProgressResult getPipelineChangeProgressResult = (GetPipelineChangeProgressResult)response.getAwsResponse();
            return getPipelineChangeProgressResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPipelineBlueprintsResult listPipelineBlueprints(ListPipelineBlueprintsRequest request) {
        request = (ListPipelineBlueprintsRequest)this.beforeClientExecution(request);
        return this.executeListPipelineBlueprints(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListPipelineBlueprintsResult executeListPipelineBlueprints(ListPipelineBlueprintsRequest listPipelineBlueprintsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPipelineBlueprintsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPipelineBlueprintsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPipelineBlueprintsRequestProtocolMarshaller(protocolFactory).marshall((ListPipelineBlueprintsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listPipelineBlueprintsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"OSIS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListPipelineBlueprints");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPipelineBlueprintsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListPipelineBlueprintsResult listPipelineBlueprintsResult = (ListPipelineBlueprintsResult)response.getAwsResponse();
            return listPipelineBlueprintsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPipelinesResult listPipelines(ListPipelinesRequest request) {
        request = (ListPipelinesRequest)this.beforeClientExecution(request);
        return this.executeListPipelines(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListPipelinesResult executeListPipelines(ListPipelinesRequest listPipelinesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPipelinesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPipelinesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPipelinesRequestProtocolMarshaller(protocolFactory).marshall((ListPipelinesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listPipelinesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"OSIS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListPipelines");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPipelinesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListPipelinesResult listPipelinesResult = (ListPipelinesResult)response.getAwsResponse();
            return listPipelinesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"OSIS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartPipelineResult startPipeline(StartPipelineRequest request) {
        request = (StartPipelineRequest)this.beforeClientExecution(request);
        return this.executeStartPipeline(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartPipelineResult executeStartPipeline(StartPipelineRequest startPipelineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startPipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartPipelineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartPipelineRequestProtocolMarshaller(protocolFactory).marshall((StartPipelineRequest)super.beforeMarshalling((AmazonWebServiceRequest)startPipelineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"OSIS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartPipeline");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartPipelineResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartPipelineResult startPipelineResult = (StartPipelineResult)response.getAwsResponse();
            return startPipelineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopPipelineResult stopPipeline(StopPipelineRequest request) {
        request = (StopPipelineRequest)this.beforeClientExecution(request);
        return this.executeStopPipeline(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopPipelineResult executeStopPipeline(StopPipelineRequest stopPipelineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopPipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopPipelineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopPipelineRequestProtocolMarshaller(protocolFactory).marshall((StopPipelineRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopPipelineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"OSIS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StopPipeline");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopPipelineResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopPipelineResult stopPipelineResult = (StopPipelineResult)response.getAwsResponse();
            return stopPipelineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"OSIS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"OSIS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdatePipelineResult updatePipeline(UpdatePipelineRequest request) {
        request = (UpdatePipelineRequest)this.beforeClientExecution(request);
        return this.executeUpdatePipeline(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdatePipelineResult executeUpdatePipeline(UpdatePipelineRequest updatePipelineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updatePipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdatePipelineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdatePipelineRequestProtocolMarshaller(protocolFactory).marshall((UpdatePipelineRequest)super.beforeMarshalling((AmazonWebServiceRequest)updatePipelineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"OSIS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdatePipeline");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdatePipelineResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdatePipelineResult updatePipelineResult = (UpdatePipelineResult)response.getAwsResponse();
            return updatePipelineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ValidatePipelineResult validatePipeline(ValidatePipelineRequest request) {
        request = (ValidatePipelineRequest)this.beforeClientExecution(request);
        return this.executeValidatePipeline(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ValidatePipelineResult executeValidatePipeline(ValidatePipelineRequest validatePipelineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(validatePipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ValidatePipelineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ValidatePipelineRequestProtocolMarshaller(protocolFactory).marshall((ValidatePipelineRequest)super.beforeMarshalling((AmazonWebServiceRequest)validatePipelineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"OSIS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ValidatePipeline");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ValidatePipelineResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ValidatePipelineResult validatePipelineResult = (ValidatePipelineResult)response.getAwsResponse();
            return validatePipelineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

