/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.GetDistributionConfigRequest;
import com.amazonaws.transform.Marshaller;

public class GetDistributionConfigRequestMarshaller
implements Marshaller<Request<GetDistributionConfigRequest>, GetDistributionConfigRequest> {
    @Override
    public Request<GetDistributionConfigRequest> marshall(GetDistributionConfigRequest getDistributionConfigRequest) {
        if (getDistributionConfigRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetDistributionConfigRequest> request = new DefaultRequest<GetDistributionConfigRequest>(getDistributionConfigRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "2014-10-21/distribution/{Id}/config";
        uriResourcePath = uriResourcePath.replace("{Id}", this.getString(getDistributionConfigRequest.getId()));
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

