/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iotanalytics.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.iotanalytics.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * DatastoreStorageMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class DatastoreStorageMarshaller {

    private static final MarshallingInfo<StructuredPojo> SERVICEMANAGEDS3_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serviceManagedS3").build();
    private static final MarshallingInfo<StructuredPojo> CUSTOMERMANAGEDS3_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("customerManagedS3").build();
    private static final MarshallingInfo<StructuredPojo> IOTSITEWISEMULTILAYERSTORAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("iotSiteWiseMultiLayerStorage").build();

    private static final DatastoreStorageMarshaller instance = new DatastoreStorageMarshaller();

    public static DatastoreStorageMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(DatastoreStorage datastoreStorage, ProtocolMarshaller protocolMarshaller) {

        if (datastoreStorage == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(datastoreStorage.getServiceManagedS3(), SERVICEMANAGEDS3_BINDING);
            protocolMarshaller.marshall(datastoreStorage.getCustomerManagedS3(), CUSTOMERMANAGEDS3_BINDING);
            protocolMarshaller.marshall(datastoreStorage.getIotSiteWiseMultiLayerStorage(), IOTSITEWISEMULTILAYERSTORAGE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
